/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance;

import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.assistance.AgentAiDto;
import org.thingsboard.trendz.dao.assistance.AgentAiRepository;
import org.thingsboard.trendz.domain.assistance.agent.AgentAi;
import org.thingsboard.trendz.domain.assistance.agent.AgentChangeRequest;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;

@Service
@Transactional
public class AgentAiDao {
    private static final Logger log = LoggerFactory.getLogger(AgentAiDao.class);
    private final AgentAiRepository agentAiRepository;

    @Autowired
    public AgentAiDao(AgentAiRepository agentAiRepository) {
        this.agentAiRepository = agentAiRepository;
    }

    public Optional<AgentAi> getByTypeWithLatestVersion(AiAgentType aiAgentType) {
        return this.agentAiRepository.findByTypeWithLatestVersion(aiAgentType.name()).map(AgentAiDto::toData);
    }

    public List<AgentAi> getAll() {
        return StreamSupport.stream(this.agentAiRepository.findAll().spliterator(), false).map(AgentAiDto::toData).toList();
    }

    public List<AgentAi> getAllByType(AiAgentType aiAgentType) {
        return this.agentAiRepository.findAllByType(aiAgentType.name()).stream().map(AgentAiDto::toData).toList();
    }

    public List<AgentAi> getAllByVersion(int version) {
        return this.agentAiRepository.findAllByVersion(version).stream().map(AgentAiDto::toData).toList();
    }

    public List<AgentAi> getAllWithLatestVersion() {
        return this.agentAiRepository.findAllWithLatestVersion().stream().map(AgentAiDto::toData).toList();
    }

    public List<AgentAi> getAllByTypeAndVersion(AiAgentType aiAgentType, int version) {
        return this.agentAiRepository.findAllByTypeAndVersion(aiAgentType.name(), version).stream().map(AgentAiDto::toData).toList();
    }

    public AgentAi modify(AgentChangeRequest agentChangeRequest, AiAgentType aiAgentType) {
        AgentAiDto agentAiDtoWithLatestVersion = (AgentAiDto)this.agentAiRepository.findByTypeWithLatestVersion(aiAgentType.name()).orElseThrow();
        AgentAiDto newAgentAiDto = new AgentAiDto();
        newAgentAiDto.setVersion(agentAiDtoWithLatestVersion.getVersion() + 1);
        newAgentAiDto.setId(UUID.randomUUID());
        newAgentAiDto.setSystemMessage(agentChangeRequest.getSystemMessage());
        newAgentAiDto.setAgentType(agentAiDtoWithLatestVersion.getAgentType());
        return ((AgentAiDto)this.agentAiRepository.save((Object)newAgentAiDto)).toData();
    }
}

