/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.apikey;

import jakarta.transaction.Transactional;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.apikey.ApiKeyDto;
import org.thingsboard.trendz.dao.apikey.ApiKeyRepository;
import org.thingsboard.trendz.domain.apikey.ApiKey;

@Service
@Transactional
public class ApiKeyDao {
    private static final Logger log = LoggerFactory.getLogger(ApiKeyDao.class);
    private final ApiKeyRepository apiKeyRepository;

    @Autowired
    public ApiKeyDao(ApiKeyRepository apiKeyRepository) {
        this.apiKeyRepository = apiKeyRepository;
    }

    public Optional<ApiKey> findById(UUID id) {
        return this.apiKeyRepository.findById((Object)id).map(ApiKeyDto::toData);
    }

    public Optional<ApiKey> findByTenantId(UUID tenantId) {
        return this.apiKeyRepository.findByTenantId(tenantId).map(ApiKeyDto::toData);
    }

    public Optional<ApiKey> findByToken(String token) {
        return this.apiKeyRepository.findByToken(token).map(ApiKeyDto::toData);
    }

    public ApiKey save(ApiKey apiKey) {
        return ((ApiKeyDto)this.apiKeyRepository.save((Object)ApiKeyDto.from((ApiKey)apiKey))).toData();
    }

    public void deleteById(UUID id) {
        this.apiKeyRepository.deleteById((Object)id);
    }
}

