/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller.html;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.thingsboard.trendz.exception.TrendzException;

@Controller
public class HtmlController {
    private static final Logger log = LoggerFactory.getLogger(HtmlController.class);
    private final ResourceLoader resourceLoader;

    @Autowired
    public HtmlController(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @RequestMapping(value={"/index.html"})
    public void serveCustomHtml(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String whitelabelingPrefix = (String)request.getAttribute("whitelabelingPrefix");
        Resource resource = this.resourceLoader.getResource("classpath:/resources/index.html");
        response.setStatus(200);
        response.setContentType("text/html");
        if (whitelabelingPrefix == null) {
            FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)response.getOutputStream());
        } else {
            String before = "<base href=\"/trendz/\">";
            String after = String.format("<base href=\"/%s/\">", whitelabelingPrefix);
            StringBuilder modifiedHtml = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    modifiedHtml.append(line.replace(before, after));
                    modifiedHtml.append(System.lineSeparator());
                }
            }
            response.getOutputStream().write(modifiedHtml.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    private void validateHtmlExists(Resource resource) {
        try {
            resource.getFile();
        }
        catch (FileNotFoundException e) {
            throw new TrendzException("The fronted static files are not present");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

