/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller.error;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.html.HtmlController;
import org.thingsboard.trendz.tools.json.JsonUtils;

@RestController
public class DefaultErrorController
implements ErrorController {
    private static final Logger log = LoggerFactory.getLogger(DefaultErrorController.class);
    private final HtmlController htmlController;
    private final BasicErrorController basicErrorController;
    private static final String PREFIX = "/apiTrendz";

    @Autowired
    public DefaultErrorController(HtmlController htmlController) {
        this.htmlController = htmlController;
        this.basicErrorController = this.basicErrorController();
    }

    @RequestMapping(value={"${server.error.path}"})
    public void defaultErrorMessage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Integer status = (Integer)request.getAttribute("jakarta.servlet.error.status_code");
        if (status != null && status == 404) {
            String originalUri = (String)request.getAttribute("whitelabelingNewPath");
            if (originalUri != null && originalUri.startsWith(PREFIX)) {
                this.handleByBasicErrorController(request, response);
            } else {
                this.htmlController.serveCustomHtml(request, response);
            }
        } else {
            this.handleByBasicErrorController(request, response);
        }
    }

    private BasicErrorController basicErrorController() {
        DefaultErrorAttributes errorAttributes = new DefaultErrorAttributes();
        ErrorProperties errorProperties = new ErrorProperties();
        errorProperties.setIncludeMessage(ErrorProperties.IncludeAttribute.ALWAYS);
        return new BasicErrorController((ErrorAttributes)errorAttributes, errorProperties);
    }

    private void handleByBasicErrorController(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ResponseEntity errorResponse = this.basicErrorController.error(request);
        response.setStatus(errorResponse.getStatusCodeValue());
        response.setContentType("application/json");
        response.getWriter().write(JsonUtils.toJson((Object)((Map)errorResponse.getBody())));
    }

    public HtmlController getHtmlController() {
        return this.htmlController;
    }

    public BasicErrorController getBasicErrorController() {
        return this.basicErrorController;
    }
}

