/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.UUID;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.script.ValidationScriptErrorInfo;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.exception.service.script.ScriptProcessingException;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.script.ScriptFieldPreprocessor;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.ViewReportBuildJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;

@RestController
@RequestMapping(value={"/apiTrendz/view/runtime/"})
public class ViewController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ViewController.class);
    private final TaskService taskService;
    private final ScriptFieldPreprocessor scriptFieldPreprocessor;

    @Autowired
    public ViewController(TaskService taskService, ScriptFieldPreprocessor scriptFieldPreprocessor) {
        this.taskService = taskService;
        this.scriptFieldPreprocessor = scriptFieldPreprocessor;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/run"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> buildReportAsync(@RequestBody ViewConfig viewConfig) {
        JwtSecurityUser user = this.getSecurityUser();
        String referenceKey = viewConfig.getId() == null ? user.getTenantCustomerKey() : viewConfig.getId().toString();
        TaskReference reference = new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_BUILD_VIEW, referenceKey);
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference, true).orElseThrow(() -> new TaskNotFoundException(reference));
        ViewReportBuildJob job = ViewReportBuildJob.builder().viewConfig(viewConfig).build();
        UUID executionId = this.taskService.runExecution(user, task.getId(), (TaskJob)job, false, true);
        return ResponseEntity.ok((Object)executionId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/validateScript"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> validateScript(@RequestBody ViewField viewField) {
        JwtSecurityUser user = this.getSecurityUser();
        try {
            this.scriptFieldPreprocessor.process(viewField, user);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)new ValidationScriptErrorInfo(false));
        }
        catch (IllegalArgumentException | NotImplementedException | BadConfiguredTaskException e) {
            Throwable throwable;
            if (e.getCause() != null && (throwable = e.getCause()) instanceof ScriptProcessingException) {
                ScriptProcessingException scriptException = (ScriptProcessingException)throwable;
                return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)new ValidationScriptErrorInfo(true, scriptException.getFixedMessage(), scriptException.getLine(), scriptException.getColumn()));
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)new ValidationScriptErrorInfo(true, e.getMessage(), -1L, -1));
        }
        catch (Throwable e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new ValidationScriptErrorInfo(true));
        }
    }
}

