/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigLite;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfigSortingField;
import org.thingsboard.trendz.exception.view.ViewConfigNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.ViewConfigService;
import org.thingsboard.trendz.tools.PaginationPage;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/view/config"})
public class ViewConfigController
extends BaseController {
    private final ViewConfigService viewConfigService;

    @Autowired
    public ViewConfigController(ViewConfigService viewConfigService) {
        this.viewConfigService = viewConfigService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/favorite"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAllFavoriteConfigs(@RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="10") String pageSizeStr, @RequestParam(value="sort", required=false, defaultValue="createdAt:desc") List<String> sort) {
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List<ViewConfigSortingField> sortingFields = sort.stream().map(ViewConfigSortingField::fromString).toList();
        PaginationPage allFavorites = this.viewConfigService.getFavoriteConfigs(this.getSecurityUser(), page, pageSize, sortingFields);
        return ResponseEntity.ok((Object)allFavorites);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/favorite/{id}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> addFavoriteConfig(@PathVariable(value="id") String configIdStr) {
        UUID configId = UUIDUtils.parse((String)configIdStr);
        boolean added = this.viewConfigService.addFavoriteConfig(this.getSecurityUser(), configId);
        return ResponseEntity.ok((Object)added);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/favorite/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> removeFavoriteConfig(@PathVariable(value="id") String configIdStr) {
        UUID configId = UUIDUtils.parse((String)configIdStr);
        boolean deleted = this.viewConfigService.removeFavoriteConfig(this.getSecurityUser(), configId);
        return ResponseEntity.ok((Object)deleted);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/filter/{prefix}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAllConfigsByWord(@PathVariable(value="prefix") String prefix, @RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="10") String pageSizeStr, @RequestParam(value="sort", required=false, defaultValue="createdAt:desc") List<String> sort) {
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List<ViewConfigSortingField> sortingFields = sort.stream().map(ViewConfigSortingField::fromString).toList();
        PaginationPage allByWord = this.viewConfigService.getAllConfigsByWord(this.getSecurityUser(), prefix, page, pageSize, sortingFields);
        return ResponseEntity.ok((Object)allByWord);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAllConfigs(@RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="10") String pageSizeStr, @RequestParam(value="sort", required=false, defaultValue="createdAt:desc") List<String> sort) {
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List<ViewConfigSortingField> sortingFields = sort.stream().map(ViewConfigSortingField::fromString).toList();
        PaginationPage all = this.viewConfigService.getAllLite(this.getSecurityUser(), page, pageSize, sortingFields);
        return ResponseEntity.ok((Object)all);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/all/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAllConfigsByParent(@PathVariable(value="id") String collectionIdStr, @RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="10") String pageSizeStr, @RequestParam(value="sort", required=false, defaultValue="createdAt:desc") List<String> sort) {
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        UUID collectionId = UUIDUtils.parse((String)collectionIdStr);
        List<ViewConfigSortingField> sortingFields = sort.stream().map(ViewConfigSortingField::fromString).toList();
        PaginationPage all = this.viewConfigService.getAllLiteByCollection(this.getSecurityUser(), collectionId, page, pageSize, sortingFields);
        return ResponseEntity.ok((Object)all);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{configId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> findById(@PathVariable(value="configId") String strConfigId) {
        UUID configId = UUIDUtils.parse((String)strConfigId);
        ViewConfig config = (ViewConfig)this.viewConfigService.findConfigById(this.getSecurityUser(), configId, true).orElseThrow(() -> new ViewConfigNotFoundException(configId));
        if (this.getSecurityUser().isCustomerUser() && CollectionUtils.isNotEmpty((Collection)config.getRuntimeFilters())) {
            config.getRuntimeFilters().forEach(rf -> rf.setOptions(Collections.emptySet()));
        }
        return ResponseEntity.ok((Object)config);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/rename/{configId}/{name}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> rename(@PathVariable(value="configId") String strConfigId, @PathVariable(value="name") String name) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID configId = UUIDUtils.parse((String)strConfigId);
        boolean renamed = this.viewConfigService.renameConfig(user, configId, name);
        return ResponseEntity.ok((Object)renamed);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> save(@RequestBody ViewConfig viewConfig) {
        ViewConfig savedConfig = this.viewConfigService.saveConfig(this.getSecurityUser(), viewConfig);
        return ResponseEntity.ok((Object)savedConfig);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/duplicate/{configId}/{name}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> duplicate(@PathVariable(value="configId") String strConfigId, @PathVariable(value="name") String name) {
        UUID configId = UUIDUtils.parse((String)strConfigId);
        ViewConfigLite config = this.viewConfigService.duplicateConfig(this.getSecurityUser(), configId, name);
        return ResponseEntity.ok((Object)config);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{configId}/{collectionId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> move(@PathVariable(value="configId") String strConfigId, @PathVariable(value="collectionId") String strCollectionId) {
        UUID configId = UUIDUtils.parse((String)strConfigId);
        UUID collectionId = UUIDUtils.parse((String)strCollectionId);
        boolean moved = this.viewConfigService.moveConfig(this.getSecurityUser(), configId, collectionId);
        return ResponseEntity.ok((Object)moved);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{collectionId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> moveSet(@PathVariable(value="collectionId") String strCollectionId, @RequestBody Set<String> strConfigIdSet) {
        UUID collectionId = UUIDUtils.parse((String)strCollectionId);
        Set configIdSet = strConfigIdSet.stream().map(UUIDUtils::parse).collect(Collectors.toSet());
        boolean moved = this.viewConfigService.moveConfigSet(this.getSecurityUser(), configIdSet, collectionId);
        return ResponseEntity.ok((Object)moved);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/delete/{configId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> delete(@PathVariable(value="configId") String strConfigId) {
        UUID configId = UUIDUtils.parse((String)strConfigId);
        boolean deleted = this.viewConfigService.deleteConfig(this.getSecurityUser(), configId);
        return ResponseEntity.ok((Object)deleted);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/deleteSet"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> deleteAll(@RequestBody Set<String> strConfigIdSet) {
        Set configIdSet = strConfigIdSet.stream().map(UUIDUtils::parse).collect(Collectors.toSet());
        boolean deleted = this.viewConfigService.deleteConfigSet(this.getSecurityUser(), configIdSet);
        return ResponseEntity.ok((Object)deleted);
    }
}

