/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.tb.dashboard.entity.DashboardData;
import org.thingsboard.trendz.domain.tb.dashboard.request.DashboardExportRequest;
import org.thingsboard.trendz.domain.tb.dashboard.request.DashboardExportViewsRequest;
import org.thingsboard.trendz.domain.tb.dashboard.response.DashboardExportResponse;
import org.thingsboard.trendz.domain.tb.trendz_settings.RefreshTrendzSettingsRequest;
import org.thingsboard.trendz.domain.tb.widget.base.TbResourceStatus;
import org.thingsboard.trendz.domain.tb.widget.base.UploadTbResourceStatus;
import org.thingsboard.trendz.domain.tb.widget.base.UploadWidgetBundleRequest;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.tb.dashboard.DashboardService;
import org.thingsboard.trendz.service.tb.module.TbModuleService;
import org.thingsboard.trendz.service.tb.trendz_settings.TbTrendzSettingsService;
import org.thingsboard.trendz.service.tb.widget.NativeWidgetBundleService;
import org.thingsboard.trendz.service.tb.widget.NativeWidgetBundleServiceComposite;

@RestController
@RequestMapping(value={"/apiTrendz/tb"})
public class TbController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(TbController.class);
    private final NativeWidgetBundleService nativeWidgetBundleService;
    private final DashboardService dashboardService;
    private final TbModuleService tbModuleService;
    private final TbTrendzSettingsService tbTrendzSettingsService;

    @Autowired
    public TbController(NativeWidgetBundleServiceComposite nativeWidgetBundleService, DashboardService dashboardService, TbModuleService tbModuleService, TbTrendzSettingsService tbTrendzSettingsService) {
        this.nativeWidgetBundleService = nativeWidgetBundleService;
        this.dashboardService = dashboardService;
        this.tbModuleService = tbModuleService;
        this.tbTrendzSettingsService = tbTrendzSettingsService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/bundle-exists"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> bundleExists() {
        JwtSecurityUser user = this.getSecurityUser();
        boolean bundleExists = this.nativeWidgetBundleService.bundleExists(user);
        log.info("Widget bundle exists: {}", (Object)bundleExists);
        return ResponseEntity.ok((Object)bundleExists);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/get-bundle-status"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> getWidgetBundleStatus(HttpServletRequest request, @RequestBody UploadWidgetBundleRequest bundleRequest) {
        JwtSecurityUser user = this.getSecurityUser();
        String domain = request.getServerName();
        String externalUrl = bundleRequest.getTrendzUrl();
        log.info("Widget bundle status request, domain: {}, external URL: {}", (Object)domain, (Object)externalUrl);
        TbResourceStatus bundleStatus = this.nativeWidgetBundleService.getBundleStatus(user, domain, externalUrl);
        log.info("Widget bundle status: {}", (Object)bundleStatus);
        return ResponseEntity.ok((Object)bundleStatus);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/upload-native-widget-bundle"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> uploadNativeWidgetBundle(HttpServletRequest request, @RequestBody UploadWidgetBundleRequest bundleRequest) {
        JwtSecurityUser user = this.getSecurityUser();
        String domain = request.getServerName();
        String externalUrl = bundleRequest.getTrendzUrl();
        log.info("Widget bundle update request, domain: {}, external URL: {}", (Object)domain, (Object)externalUrl);
        UploadTbResourceStatus bundleStatus = this.nativeWidgetBundleService.uploadNativeWidgetBundle(user, domain, externalUrl);
        return ResponseEntity.ok((Object)bundleStatus);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/get-module-status"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getModuleStatus(HttpServletRequest request) {
        String domain = request.getServerName();
        JwtSecurityUser user = this.getSecurityUser();
        TbResourceStatus resourceStatus = this.tbModuleService.getModuleStatus(user, domain);
        return ResponseEntity.ok((Object)resourceStatus);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/upload-module"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> uploadModule(HttpServletRequest request) {
        String domain = request.getServerName();
        JwtSecurityUser user = this.getSecurityUser();
        UploadTbResourceStatus resourceStatus = this.tbModuleService.uploadModule(user, domain);
        return ResponseEntity.ok((Object)resourceStatus);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/trendz-settings/get"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> getTrendzSettings(HttpServletRequest request, @RequestBody RefreshTrendzSettingsRequest refreshRequest) {
        String domain = request.getServerName();
        JwtSecurityUser user = this.getSecurityUser();
        String url = refreshRequest.getTrendzUrl();
        TbResourceStatus trendzSettingsStatus = this.tbTrendzSettingsService.checkSettings(user, domain, url);
        return ResponseEntity.ok((Object)trendzSettingsStatus);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/trendz-settings/set"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> setTrendzSettings(HttpServletRequest request, @RequestBody RefreshTrendzSettingsRequest refreshRequest) {
        String domain = request.getServerName();
        JwtSecurityUser user = this.getSecurityUser();
        String url = refreshRequest.getTrendzUrl();
        UploadTbResourceStatus trendzSettingsStatus = this.tbTrendzSettingsService.refreshSettings(user, domain, url);
        return ResponseEntity.ok((Object)trendzSettingsStatus);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/load-all-dashboard-labels"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAllDashboardLabels() {
        String jwtToken = this.getJwtToken();
        List allDashboardLites = this.dashboardService.getAllDashboardLabels(jwtToken);
        return ResponseEntity.ok((Object)allDashboardLites);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/load-dashboard/{dashboardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getDashboard(@PathVariable(value="dashboardId") UUID dashboardId) {
        String jwtToken = this.getJwtToken();
        DashboardData dashboard = this.dashboardService.loadSelectedDashboard(dashboardId, jwtToken);
        return ResponseEntity.ok((Object)dashboard);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/export-view-to-dashboard"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> exportCurrentViewOnDashboard(HttpServletRequest request, @Valid @RequestBody DashboardExportRequest dashboardExportRequest) {
        String domain = request.getServerName();
        JwtSecurityUser user = this.getSecurityUser();
        String jwtToken = this.getJwtToken();
        DashboardExportResponse result = this.dashboardService.exportCurrentViewOnDashboard(dashboardExportRequest.getIsNewDashboard().booleanValue(), dashboardExportRequest.getDashboardName(), dashboardExportRequest.getDashboardId(), dashboardExportRequest.getDashboardState(), dashboardExportRequest.getEntityId(), user, jwtToken, domain, dashboardExportRequest.getUrl(), dashboardExportRequest.getViewConfigId(), dashboardExportRequest.getFilterName());
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/export-views-to-dashboard"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> exportSelectedViewsOnDashboard(HttpServletRequest request, @Valid @RequestBody DashboardExportViewsRequest dashboardExportViewsRequest) {
        String domain = request.getServerName();
        DashboardExportResponse result = this.dashboardService.exportSelectedViewsOnDashboard(dashboardExportViewsRequest, this.getJwtToken(), domain, this.getSecurityUser());
        return ResponseEntity.ok((Object)result);
    }
}

