/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.controller.TaskController;
import org.thingsboard.trendz.exception.task.TaskExecutionNotFoundException;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.exception.task.TaskSequenceNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.TokenExtractor;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskSequenceService;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.TestJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskConfig;
import org.thingsboard.trendz.service.task.model.TaskExecution;
import org.thingsboard.trendz.service.task.model.TaskExecutionFilteringField;
import org.thingsboard.trendz.service.task.model.TaskExecutionSortingField;
import org.thingsboard.trendz.service.task.model.TaskFilteringField;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.service.task.model.TaskSchedule;
import org.thingsboard.trendz.service.task.model.TaskScheduleType;
import org.thingsboard.trendz.service.task.model.TaskSequence;
import org.thingsboard.trendz.service.task.model.TaskSequenceConfig;
import org.thingsboard.trendz.service.task.model.TaskSequenceFilteringField;
import org.thingsboard.trendz.service.task.model.TaskSequenceSortingField;
import org.thingsboard.trendz.service.task.model.TaskSortingField;
import org.thingsboard.trendz.service.task.model.TaskTimeoutConfig;
import org.thingsboard.trendz.service.task.model.TaskWebRequest;
import org.thingsboard.trendz.tools.DateTimeUtils;
import org.thingsboard.trendz.tools.PaginationPage;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/task"})
public class TaskController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(TaskController.class);
    private final TaskService taskService;
    private final TaskSequenceService taskSequenceService;
    private final TokenExtractor tokenExtractor;

    @Autowired
    public TaskController(TaskService taskService, TaskSequenceService taskSequenceService, TokenExtractor tokenExtractor) {
        this.taskService = taskService;
        this.taskSequenceService = taskSequenceService;
        this.tokenExtractor = tokenExtractor;
    }

    @MessageMapping(value={"/scriptExecution"})
    public void processMessage(@Payload TaskWebRequest request) {
        JwtSecurityUser securityUser = this.tokenExtractor.extractUser(request.getJwtToken());
        UUID taskId = request.getTaskId();
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/test/create"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> createTestTask() {
        JwtSecurityUser user = this.getSecurityUser();
        String name = "Test task " + String.valueOf(DateTimeUtils.fromTs((long)System.currentTimeMillis()));
        TestJob job = TestJob.builder().input(name).build();
        TaskConfig taskConfig = TaskConfig.builder().name(name).job((TaskJob)job).schedule(new TaskSchedule(TaskScheduleType.NONE, 0L, 0L, ChronoUnit.HOURS, 1, ZoneId.systemDefault().toString())).build();
        Task task = this.taskService.createTask(user, taskConfig);
        return ResponseEntity.ok((Object)task);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/test/update/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> updateTestTask(@PathVariable(value="taskId") String taskIdStr) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID taskId = UUIDUtils.parse((String)taskIdStr);
        String name = "Test task " + String.valueOf(DateTimeUtils.fromTs((long)System.currentTimeMillis()));
        TestJob job = TestJob.builder().input(name).build();
        TaskConfig taskConfig = TaskConfig.builder().id(taskId).name(name).timeoutConfig(new TaskTimeoutConfig(true, 5000L)).job((TaskJob)job).build();
        Task task = this.taskService.updateTask(user, taskConfig);
        return ResponseEntity.ok((Object)task);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAllTasksLite(@RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="1000") String pageSizeStr, @RequestParam(value="filter", required=false, defaultValue="") List<String> filter, @RequestParam(value="sort", required=false, defaultValue="createdTs:desc") List<String> sort) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List filteringFields = filter.stream().map(TaskFilteringField::fromString).collect(Collectors.toList());
        List sortingFields = sort.stream().map(TaskSortingField::fromString).collect(Collectors.toList());
        Page allLite = this.taskService.getAllTasksLite(securityUser, page, pageSize, filteringFields, sortingFields);
        PaginationPage allLitePage = new PaginationPage(allLite);
        return ResponseEntity.ok((Object)allLitePage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/all/full"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAllTasks(@RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="1000") String pageSizeStr, @RequestParam(value="filter", required=false, defaultValue="") List<String> filter, @RequestParam(value="sort", required=false, defaultValue="createdTs:desc") List<String> sort) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List filteringFields = filter.stream().map(TaskFilteringField::fromString).collect(Collectors.toList());
        List sortingFields = sort.stream().map(TaskSortingField::fromString).collect(Collectors.toList());
        Page all = this.taskService.getAllTasks(securityUser, page, pageSize, filteringFields, sortingFields);
        PaginationPage allPage = new PaginationPage(all);
        return ResponseEntity.ok((Object)allPage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> findTaskById(@PathVariable(value="taskId") String taskIdStr) {
        UUID taskId = UUIDUtils.parse((String)taskIdStr);
        JwtSecurityUser securityUser = this.getSecurityUser();
        Task task = (Task)this.taskService.findTaskById(securityUser, taskId, true).orElseThrow(() -> new TaskNotFoundException(taskId));
        return ResponseEntity.ok((Object)task);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/reference/{referenceType}/{key}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> findTaskByReferencedEntity(@PathVariable(value="referenceType") String typeStr, @PathVariable(value="key") String key) {
        TaskReferencedEntityType type = TaskReferencedEntityType.parse((String)typeStr);
        JwtSecurityUser securityUser = this.getSecurityUser();
        TaskReference reference = new TaskReference(type, key);
        Task task = (Task)this.taskService.findTaskByReferencedEntity(securityUser, reference, true).orElseThrow(() -> new TaskNotFoundException(reference));
        return ResponseEntity.ok((Object)task);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/execution/all"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAllExecutionsLite(@RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="1000") String pageSizeStr, @RequestParam(value="filter", required=false, defaultValue="") List<String> filter, @RequestParam(value="sort", required=false, defaultValue="createdTs:desc") List<String> sort) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List filteringFields = filter.stream().map(TaskExecutionFilteringField::fromString).collect(Collectors.toList());
        List sortingFields = sort.stream().map(TaskExecutionSortingField::fromString).collect(Collectors.toList());
        Page allLite = this.taskService.getAllTaskExecutionsLite(securityUser, page, pageSize, filteringFields, sortingFields);
        PaginationPage allLitePage = new PaginationPage(allLite);
        return ResponseEntity.ok((Object)allLitePage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/execution/task/all"}, method={RequestMethod.GET})
    public ResponseEntity<?> getAllTaskExecutionsByTaskLite(@RequestParam(value="taskId") String taskIdStr, @RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="1000") String pageSizeStr, @RequestParam(value="filter", required=false, defaultValue="") List<String> filter, @RequestParam(value="sort", required=false, defaultValue="createdTs:desc") List<String> sort) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        UUID taskId = UUIDUtils.parse((String)taskIdStr);
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List filteringFields = filter.stream().map(TaskExecutionFilteringField::fromString).collect(Collectors.toList());
        List sortingFields = sort.stream().map(TaskExecutionSortingField::fromString).collect(Collectors.toList());
        Page allLite = this.taskService.getAllTaskExecutionsByTaskLite(securityUser, taskId, page, pageSize, filteringFields, sortingFields);
        PaginationPage allLitePage = new PaginationPage(allLite);
        return ResponseEntity.ok((Object)allLitePage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/execution/{taskExecutionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> findTaskExecutionById(@PathVariable(value="taskExecutionId") String taskExecutionIdStr) {
        UUID taskExecutionId = UUIDUtils.parse((String)taskExecutionIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        TaskExecution execution = (TaskExecution)this.taskService.findExecutionById(user, taskExecutionId).orElseThrow(() -> new TaskExecutionNotFoundException(taskExecutionId));
        return ResponseEntity.ok((Object)execution);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/execution/poll/{taskExecutionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> pollTaskExecutionById(@PathVariable(value="taskExecutionId") String taskExecutionIdStr) {
        UUID taskExecutionId = UUIDUtils.parse((String)taskExecutionIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        TaskExecution execution = this.taskService.pollExecutionById(user, taskExecutionId);
        return ResponseEntity.ok((Object)execution);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/execution/await/{taskExecutionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> awaitTaskExecutionById(@PathVariable(value="taskExecutionId") String taskExecutionIdStr) throws TimeoutException {
        UUID taskExecutionId = UUIDUtils.parse((String)taskExecutionIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        TaskExecution execution = this.taskService.awaitExecution(user, taskExecutionId);
        return ResponseEntity.ok((Object)execution);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/run/{taskId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> runTask(@PathVariable(value="taskId") String taskIdStr, @RequestParam(value="cancel", required=false, defaultValue="false") String cancelStr, @RequestParam(value="forced", required=false, defaultValue="false") String forcedStr) {
        UUID executionId;
        UUID taskId = UUIDUtils.parse((String)taskIdStr);
        boolean cancel = Boolean.parseBoolean(cancelStr);
        boolean forced = Boolean.parseBoolean(forcedStr);
        JwtSecurityUser user = this.getSecurityUser();
        Task task = (Task)this.taskService.findTaskById(user, taskId, true).orElseThrow(() -> new TaskNotFoundException(taskId));
        if (forced) {
            executionId = this.taskService.runExecution(user, taskId, cancel);
        } else {
            switch (1.$SwitchMap$org$thingsboard$trendz$service$task$model$TaskScheduleType[task.getSchedule().getType().ordinal()]) {
                case 1: 
                case 2: {
                    executionId = this.taskService.runExecution(user, taskId, cancel);
                    break;
                }
                default: {
                    this.taskService.resetTaskScheduling(user, taskId);
                    executionId = EntityId.NULL_UUID;
                }
            }
        }
        return ResponseEntity.ok((Object)executionId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/scheduling/{taskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getLastSchedulingTime(@PathVariable(value="taskId") String taskIdStr) {
        UUID taskId = UUIDUtils.parse((String)taskIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        long schedulingTime = (Long)this.taskService.getTaskSchedulingTime(user, taskId).orElseThrow(() -> new TaskNotFoundException(taskId));
        return ResponseEntity.ok((Object)schedulingTime);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/execution/cancel/{taskExecutionId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> cancelTaskExecution(@PathVariable(value="taskExecutionId") String taskExecutionIdStr) {
        UUID taskExecutionId = UUIDUtils.parse((String)taskExecutionIdStr);
        JwtSecurityUser securityUser = this.getSecurityUser();
        this.taskService.cancelExecutionById(securityUser, taskExecutionId);
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/execution/cancel/task/{taskId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> cancelAllTaskExecutionByTask(@PathVariable(value="taskId") String taskIdStr) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        UUID taskId = UUIDUtils.parse((String)taskIdStr);
        this.taskService.cancelExecutionsByTaskId(securityUser, taskId);
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/execution/cancel/all"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> cancelAllTaskExecutionByUser() {
        JwtSecurityUser securityUser = this.getSecurityUser();
        this.taskService.cancelAllExecutions(securityUser);
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/execution/delete/all"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteAllTaskExecutionByUser() {
        JwtSecurityUser securityUser = this.getSecurityUser();
        this.taskService.deleteAllExecutions(securityUser);
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/sequence/all"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAllSequences(@RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="1000") String pageSizeStr, @RequestParam(value="filter", required=false, defaultValue="") List<String> filter, @RequestParam(value="sort", required=false, defaultValue="createdTs:desc") List<String> sort) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List filteringFields = filter.stream().map(TaskSequenceFilteringField::fromString).collect(Collectors.toList());
        List sortingFields = sort.stream().map(TaskSequenceSortingField::fromString).collect(Collectors.toList());
        Page all = this.taskSequenceService.getAllTaskSequences(securityUser, page, pageSize, filteringFields, sortingFields);
        PaginationPage allLitePage = new PaginationPage(all);
        return ResponseEntity.ok((Object)allLitePage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/sequence/{sequenceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> findSequenceById(@PathVariable(value="sequenceId") String sequenceIdStr) {
        UUID sequenceId = UUIDUtils.parse((String)sequenceIdStr);
        JwtSecurityUser securityUser = this.getSecurityUser();
        TaskSequence taskSequence = (TaskSequence)this.taskSequenceService.findTaskSequenceById(securityUser, sequenceId, true).orElseThrow(() -> new TaskSequenceNotFoundException(sequenceId));
        return ResponseEntity.ok((Object)taskSequence);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/sequence"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> saveSequence(@RequestBody TaskSequenceConfig config) {
        JwtSecurityUser user = this.getSecurityUser();
        TaskSequence saved = this.taskSequenceService.saveTaskSequence(user, config);
        return ResponseEntity.ok((Object)saved);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/sequence/{sequenceId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteSequenceById(@PathVariable(value="sequenceId") String sequenceIdStr) {
        UUID sequenceId = UUIDUtils.parse((String)sequenceIdStr);
        JwtSecurityUser securityUser = this.getSecurityUser();
        this.taskSequenceService.deleteTaskSequence(securityUser, sequenceId);
        return ResponseEntity.ok((Object)"Deleted");
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/sequence/run/{sequenceId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> runSequence(@PathVariable(value="sequenceId") String sequenceIdStr) {
        UUID sequenceId = UUIDUtils.parse((String)sequenceIdStr);
        JwtSecurityUser securityUser = this.getSecurityUser();
        UUID executionId = this.taskSequenceService.runSequence(securityUser, sequenceId);
        return ResponseEntity.ok((Object)executionId);
    }
}

