/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.apikey.ApiKeyEntry;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;
import org.thingsboard.trendz.security.entity.AuthToken;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.ApiKeyService;
import org.thingsboard.trendz.service.cache.CachedTelemetryService;
import org.thingsboard.trendz.service.customize.CustomizationService;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.service.system.SigningKeySetupService;
import org.thingsboard.trendz.service.system.SysadminCredentials;
import org.thingsboard.trendz.service.system.SysadminTokenRequest;
import org.thingsboard.trendz.subscription.LicenceService;
import org.thingsboard.trendz.subscription.TrendzLicenceInfo;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/apiTrendz/system"})
public class SystemController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(SystemController.class);
    private final CachedTelemetryService cachedTelemetryService;
    private final CacheService cacheService;
    private final LicenceService licenceService;
    private final CustomizationService customizationService;
    private final SigningKeySetupService signingKeySetupService;
    private final ApiKeyService apiKeyService;

    @Autowired
    public SystemController(CachedTelemetryService cachedTelemetryService, CacheService cacheService, LicenceService licenceService, CustomizationService customizationService, SigningKeySetupService signingKeySetupService, ApiKeyService apiKeyService) {
        this.cachedTelemetryService = cachedTelemetryService;
        this.cacheService = cacheService;
        this.licenceService = licenceService;
        this.customizationService = customizationService;
        this.signingKeySetupService = signingKeySetupService;
        this.apiKeyService = apiKeyService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/caches/telemetry/remove"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean removeTelemetryCaches() {
        DonReactive.block((Mono)this.cachedTelemetryService.removeAllCacheByTenantId(this.getSecurityUser().getTenant()));
        return true;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/caches/local/remove"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean removeLocalCaches() {
        this.cacheService.clearCaches();
        return true;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/licence/info"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> provideLicenceInfo() {
        JwtSecurityUser user = this.getSecurityUser();
        TrendzLicenceInfo licenceInfo = this.licenceService.provideLicenceInfo(user);
        return ResponseEntity.ok((Object)licenceInfo);
    }

    @RequestMapping(value={"/customization/get/public"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> provideCustomViewSettingsPublic(HttpServletRequest request) {
        String domain = request.getServerName();
        JwtSecurityUser securityUser = JwtSecurityUser.NOT_USER;
        CustomViewSettings customizationData = this.customizationService.getCustomViewSettings(domain, securityUser);
        return ResponseEntity.ok((Object)customizationData);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/customization/get"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> provideCustomViewSettings(HttpServletRequest request) {
        String domain = request.getServerName();
        JwtSecurityUser securityUser = this.getSecurityUser();
        CustomViewSettings customizationData = this.customizationService.getCustomViewSettings(domain, securityUser);
        return ResponseEntity.ok((Object)customizationData);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customization/set"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> setupCustomViewSettings(@RequestBody CustomViewSettings customizationData, HttpServletRequest request) {
        String domain = request.getServerName();
        CustomViewSettings settings = this.customizationService.setupCustomViewSettings(customizationData, domain, this.getSecurityUser());
        return ResponseEntity.ok((Object)settings);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customization/access"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> checkAccessOfWhitelabeling() {
        JwtSecurityUser securityUser = this.getSecurityUser();
        boolean enabled = this.customizationService.checkAccessOfWhiteLabeling(securityUser);
        return ResponseEntity.ok((Object)enabled);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/customization/detach"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> detachFromDomains() {
        JwtSecurityUser securityUser = this.getSecurityUser();
        this.customizationService.detachFromDomains(securityUser);
        return ResponseEntity.ok((Object)"OK");
    }

    @RequestMapping(value={"/user-language"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> fetchUserLanguage() {
        JwtSecurityUser securityUser = this.getSecurityUser();
        String userLanguage = this.customizationService.fetchUserLanguage(securityUser);
        return ResponseEntity.ok((Object)userLanguage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/signingKey/login"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> loginAsSysadmin(@Valid @RequestBody SysadminCredentials credentials) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        AuthToken authToken = this.signingKeySetupService.loginAsSysadmin(securityUser, credentials);
        return ResponseEntity.ok((Object)authToken);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/signingKey/setup"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> setupSigningKey(@Valid @RequestBody SysadminTokenRequest sysadminJwtToken) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        this.signingKeySetupService.setupSigningKey(securityUser, sysadminJwtToken);
        return ResponseEntity.ok((Object)true);
    }

    @RequestMapping(value={"/signingKey/setup/anonymously"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> setupSigningKeyAnonymously(@Valid @RequestBody SysadminCredentials credentials) {
        this.signingKeySetupService.setupSigningKeyAnonymously(credentials);
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/signingKey/check"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> checkSigningKey() {
        JwtSecurityUser securityUser = this.getSecurityUser();
        boolean isValid = this.signingKeySetupService.checkSigningKey(securityUser);
        return ResponseEntity.ok((Object)isValid);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/apiKey/get"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getApiKey() {
        JwtSecurityUser securityUser = this.getSecurityUser();
        String apiKey = this.apiKeyService.getApiKeyByTenantId(securityUser.getTenantId());
        ApiKeyEntry entry = new ApiKeyEntry(apiKey);
        return ResponseEntity.ok((Object)entry);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/apiKey/refresh"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> refreshApiKey() {
        JwtSecurityUser securityUser = this.getSecurityUser();
        this.apiKeyService.refreshApiKey(securityUser.getTenantId());
        String apiKey = this.apiKeyService.getApiKeyByTenantId(securityUser.getTenantId());
        ApiKeyEntry entry = new ApiKeyEntry(apiKey);
        return ResponseEntity.ok((Object)entry);
    }
}

