/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.PostConstruct;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.info.BuildProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.async.DeferredResult;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.simple.BuildViewByReferenceTask;
import org.thingsboard.trendz.domain.simple.SimpleApiTask;
import org.thingsboard.trendz.domain.simple.SimpleViewReport;
import org.thingsboard.trendz.domain.simple.ViewConfigReference;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.simple.SimpleApiServiceRateLimiter;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Controller
@RequestMapping(value={"/apiTrendz/publicApi"})
public class PublicApiController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(PublicApiController.class);
    @Autowired
    private SimpleApiServiceRateLimiter simpleApiServiceRateLimiter;
    @Autowired
    private BuildProperties buildProperties;
    @Value(value="${deployment.cloud}")
    private boolean cloud;
    @Value(value="${deployment.test}")
    private boolean test;

    @PostConstruct
    public void init() {
        String artifact = this.buildProperties.getArtifact();
        String version = this.buildProperties.getVersion();
        String name = this.buildProperties.getName();
        Instant time = this.buildProperties.getTime();
        log.info("{} {} {} {}", new Object[]{artifact, version, name, time});
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/buildReport"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public DeferredResult<ResponseEntity<SimpleViewReport>> buildViewByReference(@RequestBody ViewConfigReference viewConfigReference) {
        JwtSecurityUser user = this.getSecurityUser();
        BuildViewByReferenceTask task = BuildViewByReferenceTask.builder().reference(viewConfigReference).securityUser(user).build();
        DeferredResult result = new DeferredResult();
        ListenableFuture simpleApiTaskListenableFuture = this.simpleApiServiceRateLimiter.submitTask((SimpleApiTask)task);
        Futures.addCallback((ListenableFuture)simpleApiTaskListenableFuture, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)MoreExecutors.directExecutor());
        return result;
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonNode getSystemVersionInfo() {
        return this.buildInfoObject();
    }

    @RequestMapping(value={"/download/custom-action-ai-summary.js"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> downloadTrendzAiSummary() {
        ClassPathResource resource = new ClassPathResource("modules/trendz-ai-summary-manual.js");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=custom-action-ai-summary.js"})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    private JsonNode buildInfoObject() {
        ObjectNode infoObject = JsonUtils.getObjectMapper().createObjectNode();
        if (this.buildProperties != null) {
            infoObject.put("version", this.buildProperties.getVersion());
            infoObject.put("artifact", this.buildProperties.getArtifact());
            infoObject.put("name", this.buildProperties.getName());
            infoObject.put("cloud", this.cloud);
            infoObject.put("test", this.test);
            Instant time = this.buildProperties.getTime();
            String formattedTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").withZone(ZoneId.systemDefault()).format(time);
            infoObject.put("time", formattedTime);
        } else {
            infoObject.put("version", "unknown");
        }
        return infoObject;
    }
}

