/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelNotFoundException;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.model.prediction.PredictionModel;
import org.thingsboard.trendz.service.model.prediction.PredictionModelService;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyRequest;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.PredictionModelAccuracyRequestJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;

@RestController
@RequestMapping(value={"/apiTrendz/model/prediction/accuracy"})
public class PredictionModelAccuracyController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(PredictionModelAccuracyController.class);
    private final TaskService taskService;
    private final PredictionModelService predictionModelService;

    @Autowired
    public PredictionModelAccuracyController(TaskService taskService, PredictionModelService predictionModelService) {
        this.taskService = taskService;
        this.predictionModelService = predictionModelService;
    }

    @PostMapping(value={"/run"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    public ResponseEntity<?> runAccuracyRequest(@RequestBody AccuracyRequest accuracyRequest) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID modelId = accuracyRequest.getModelId();
        Set item = accuracyRequest.getItemSet();
        Set accuracyMethodDataSet = accuracyRequest.getAccuracyMethodDataSet();
        boolean autoDefineSettings = accuracyRequest.isAutoDefineSettings();
        PredictionModel model = (PredictionModel)this.predictionModelService.findById(user, modelId).orElseThrow(() -> new PredictionModelNotFoundException(modelId));
        TaskReference reference = new TaskReference(TaskReferencedEntityType.PREDICTION_MODEL_ACCURACY, modelId.toString());
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference).orElseThrow(() -> new TaskNotFoundException(reference));
        PredictionModelAccuracyRequestJob job = new PredictionModelAccuracyRequestJob(modelId, item, accuracyMethodDataSet, autoDefineSettings);
        UUID executionId = this.taskService.runExecution(user, task.getId(), (TaskJob)job, false);
        return ResponseEntity.ok((Object)executionId);
    }
}

