/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.definition.migration.MigrationData;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.migration.MigrationService;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.MigrationImportJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;

@Controller
@RequestMapping(value={"/apiTrendz/migration"})
public class MigrationController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MigrationController.class);
    private final MigrationService migrationService;
    private final TaskService taskService;

    @Autowired
    public MigrationController(MigrationService migrationService, TaskService taskService) {
        this.migrationService = migrationService;
        this.taskService = taskService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/export"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> exportMigrationData() {
        JwtSecurityUser user = this.getSecurityUser();
        MigrationData migrationData = this.migrationService.exportMigrationData(user);
        return ResponseEntity.ok((Object)migrationData);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> importMigrationData(@RequestBody MigrationData importData) {
        JwtSecurityUser user = this.getSecurityUser();
        MigrationImportJob job = new MigrationImportJob(importData);
        TaskReference taskReference = new TaskReference(TaskReferencedEntityType.MIGRATION_IMPORT, user.getTenantId().toString());
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, taskReference).orElseThrow(() -> new TaskNotFoundException(taskReference));
        UUID executionId = this.taskService.runExecution(user, task.getId(), (TaskJob)job, true);
        return ResponseEntity.ok((Object)executionId);
    }
}

