/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.assistance.model.LlmConfig;
import org.thingsboard.trendz.domain.assistance.model.LlmProvider;
import org.thingsboard.trendz.domain.assistance.model.LlmSettings;
import org.thingsboard.trendz.exception.assistance.LlmConfigNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.llm.LlmService;
import org.thingsboard.trendz.tools.PaginationPage;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/llm"})
public class LlmController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(LlmController.class);
    private final LlmService llmService;

    @Autowired
    public LlmController(LlmService llmService) {
        this.llmService = llmService;
    }

    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    public ResponseEntity<?> findAllConfigs(@RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="1000") String pageSizeStr) {
        JwtSecurityUser user = this.getSecurityUser();
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        PaginationPage allLite = this.llmService.findAll(user, page, pageSize);
        return ResponseEntity.ok((Object)allLite);
    }

    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<?> findConfig(@PathVariable(value="id") String idStr) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID id = UUIDUtils.parse((String)idStr);
        LlmConfig config = (LlmConfig)this.llmService.findById(user, id).orElseThrow(() -> new LlmConfigNotFoundException(id));
        return ResponseEntity.ok((Object)config);
    }

    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseEntity<?> saveConfig(@RequestBody LlmConfig config) {
        JwtSecurityUser user = this.getSecurityUser();
        LlmConfig saved = this.llmService.save(user, config);
        return ResponseEntity.ok((Object)saved);
    }

    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteConfig(@PathVariable(value="id") String idStr) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID id = UUIDUtils.parse((String)idStr);
        this.llmService.delete(user, id);
        return ResponseEntity.noContent().build();
    }

    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/settings"}, method={RequestMethod.GET})
    public ResponseEntity<?> getSettings() {
        JwtSecurityUser user = this.getSecurityUser();
        LlmSettings llmSettings = this.llmService.findLlmSettings(user);
        return ResponseEntity.ok((Object)llmSettings);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/settings"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> saveSettings(@RequestBody LlmSettings llmSettings) {
        JwtSecurityUser user = this.getSecurityUser();
        LlmSettings saved = this.llmService.saveLlmSettings(user, llmSettings);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)saved);
    }

    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ResponseEntity<?> getInfo() {
        Map<String, Set> result = Arrays.stream(LlmProvider.values()).flatMap(provider -> provider.getModelNames().stream().map(Enum::toString).map(modelName -> Pair.of((Object)provider.name(), (Object)modelName))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toCollection(TreeSet::new))));
        return ResponseEntity.ok(result);
    }
}

