/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.InitStatus;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.topology.InitializationService;

@RestController
@RequestMapping(value={"/apiTrendz/init"})
public class InitializationController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(InitializationController.class);
    private final InitializationService initializationService;

    @Autowired
    public InitializationController(InitializationService initializationService) {
        this.initializationService = initializationService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/status"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getInitStatus() {
        JwtSecurityUser user = this.getSecurityUser();
        InitStatus initStatus = this.initializationService.getInitStatus(user);
        return ResponseEntity.ok((Object)initStatus);
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/refresh"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> refreshTopologyAsync() {
        JwtSecurityUser user = this.getSecurityUser();
        String jwtToken = this.getJwtToken();
        InitStatus initStatus = this.initializationService.initTopology(user, jwtToken);
        return ResponseEntity.ok((Object)initStatus);
    }
}

