/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.exception.EnumParsingException;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.assistance.AiTopologyLimitException;
import org.thingsboard.trendz.exception.assistance.IncorrectLlmConfiguration;
import org.thingsboard.trendz.exception.assistance.LlmConfigNotFoundException;
import org.thingsboard.trendz.exception.assistance.LlmNameNotFoundException;
import org.thingsboard.trendz.exception.assistance.LlmProviderNotFoundException;
import org.thingsboard.trendz.exception.assistance.SystemModelNullException;
import org.thingsboard.trendz.exception.assistance.UserQuestionNullException;
import org.thingsboard.trendz.exception.assistance.customprompt.CustomPromptNotFoundException;
import org.thingsboard.trendz.exception.assistance.customprompt.TrendzCustomPromptException;
import org.thingsboard.trendz.exception.calculation.CalculationFieldNotFoundByEntityFieldException;
import org.thingsboard.trendz.exception.calculation.CalculationFieldNotFoundException;
import org.thingsboard.trendz.exception.calculation.TrendzCalculationFieldException;
import org.thingsboard.trendz.exception.chat.ChatException;
import org.thingsboard.trendz.exception.chat.ChatMessageNotFoundException;
import org.thingsboard.trendz.exception.chat.ChatNotFoundException;
import org.thingsboard.trendz.exception.chat.ChatQuotaLimitException;
import org.thingsboard.trendz.exception.definition.ItemNotFoundException;
import org.thingsboard.trendz.exception.metric.MetricDefinitionNotFoundException;
import org.thingsboard.trendz.exception.metric.TrendzMetricExplorerException;
import org.thingsboard.trendz.exception.model.anomaly.AnomalyModelNotFoundByEntityFieldException;
import org.thingsboard.trendz.exception.model.anomaly.AnomalyModelNotFoundException;
import org.thingsboard.trendz.exception.model.anomaly.AnomalyModelNullIdModelException;
import org.thingsboard.trendz.exception.model.anomaly.AnomalyModelTaskDataNotFoundException;
import org.thingsboard.trendz.exception.model.anomaly.TrendzAnomalyModelException;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelNotFoundByEntityFieldException;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelNotFoundException;
import org.thingsboard.trendz.exception.model.prediction.PredictionModelNullIdException;
import org.thingsboard.trendz.exception.predict.CustomPredictionModelNotFoundException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityFieldValidationException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.exception.service.definition.TrendzDefinitionNullIdException;
import org.thingsboard.trendz.exception.service.provider.TbWebClientException;
import org.thingsboard.trendz.exception.sql.SqlDatasourceConnectionException;
import org.thingsboard.trendz.exception.system.SigningKeySetupException;
import org.thingsboard.trendz.exception.task.TaskExecutionNotFoundException;
import org.thingsboard.trendz.exception.task.TaskExecutionNotStartedYetException;
import org.thingsboard.trendz.exception.task.TaskExecutionNullIdException;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.exception.task.TaskNullIdException;
import org.thingsboard.trendz.exception.task.TaskSequenceNotFoundException;
import org.thingsboard.trendz.exception.task.TaskSequenceNullIdException;
import org.thingsboard.trendz.exception.task.TaskWithoutExecutionsException;
import org.thingsboard.trendz.exception.view.TrendzViewException;
import org.thingsboard.trendz.exception.view.ViewCollectionNotFoundException;
import org.thingsboard.trendz.exception.view.ViewCollectionNullIdException;
import org.thingsboard.trendz.exception.view.ViewConfigNotFoundException;
import org.thingsboard.trendz.exception.view.ViewConfigNullIdException;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestControllerAdvice
public class ExceptionHandlerController {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlerController.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<?> handleMethodNotValidException(MethodArgumentNotValidException ex) {
        HashMap errors = new HashMap();
        ex.getBindingResult().getAllErrors().forEach(error -> {
            String fieldName = ((FieldError)error).getField();
            String errorMessage = error.getDefaultMessage();
            errors.put(fieldName, errorMessage);
        });
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(errors);
    }

    @ExceptionHandler(value={TrendzViewException.class, BadConfiguredTaskException.class, TrendzCalculationFieldException.class, ChatQuotaLimitException.class, AiTopologyLimitException.class, IncorrectLlmConfiguration.class, SystemModelNullException.class, TrendzMetricExplorerException.class, TrendzCustomPromptException.class, TrendzAnomalyModelException.class, TrendzDefinitionNullIdException.class, AnomalyModelNullIdModelException.class, ViewConfigNullIdException.class, ViewCollectionNullIdException.class, TaskNullIdException.class, TaskExecutionNullIdException.class, TaskSequenceNullIdException.class, PredictionModelNullIdException.class, UserQuestionNullException.class, SigningKeySetupException.class, UUIDUtils.UUIDException.class, EnumParsingException.class, BusinessEntityFieldValidationException.class, ChatException.class, SqlDatasourceConnectionException.class})
    public ResponseEntity<?> handleSimpleBadRequestExceptions(RuntimeException ex, WebRequest request) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ex.getMessage());
    }

    @ExceptionHandler(value={BusinessEntityNotFoundException.class, ViewCollectionNotFoundException.class, ViewConfigNotFoundException.class, CalculationFieldNotFoundException.class, CalculationFieldNotFoundByEntityFieldException.class, TaskNotFoundException.class, TaskExecutionNotFoundException.class, TaskWithoutExecutionsException.class, TaskSequenceNotFoundException.class, PredictionModelNotFoundException.class, PredictionModelNotFoundByEntityFieldException.class, CustomPredictionModelNotFoundException.class, ChatNotFoundException.class, ChatMessageNotFoundException.class, LlmProviderNotFoundException.class, LlmNameNotFoundException.class, CustomPromptNotFoundException.class, LlmConfigNotFoundException.class, AnomalyModelNotFoundException.class, AnomalyModelNotFoundByEntityFieldException.class, AnomalyModelTaskDataNotFoundException.class, MetricDefinitionNotFoundException.class, ItemNotFoundException.class})
    public ResponseEntity<?> handleNotFoundException(TrendzException ex, WebRequest request) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ex.getMessage());
    }

    @ExceptionHandler(value={TbWebClientException.class})
    public ResponseEntity<?> handleSimpleBadRequestExceptions(TbWebClientException ex, WebRequest request) {
        if (ex.getCause() instanceof WebClientResponseException.Unauthorized) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"You aren't authorized to perform this operation!");
        }
        log.error("The request to the Thingsboard was failed", (Throwable)ex);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("The request to the Thingsboard was failed:\n" + ex.getMessage()));
    }

    @ExceptionHandler(value={TaskExecutionNotStartedYetException.class})
    public ResponseEntity<?> handleExecutionNotStartedYetException(TaskExecutionNotStartedYetException ex, WebRequest request) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).body((Object)ex.getMessage());
    }
}

