/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPrompt;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptExecutionRequest;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptFilteringField;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptLite;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptModifyCreateRequest;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptSortingField;
import org.thingsboard.trendz.domain.assistance.summary.ViewAiSummaryRequest;
import org.thingsboard.trendz.exception.assistance.customprompt.CustomPromptDataNullException;
import org.thingsboard.trendz.exception.assistance.customprompt.CustomPromptModificationException;
import org.thingsboard.trendz.exception.assistance.customprompt.CustomPromptModifyRequestNullException;
import org.thingsboard.trendz.exception.assistance.customprompt.CustomPromptNameNullException;
import org.thingsboard.trendz.exception.assistance.customprompt.CustomPromptNullException;
import org.thingsboard.trendz.exception.assistance.customprompt.TrendzCustomPromptException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.customprompt.CustomPromptService;
import org.thingsboard.trendz.service.assistance.view.ViewAiSummaryService;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.tools.PaginationPage;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/agent/prompts"})
@ConditionalOnProperty(name={"viewAssistance.customPromptApi.enable"}, havingValue="true")
public class CustomPromptController
extends BaseController {
    private final CustomPromptService customPromptService;
    private final ViewAiSummaryService viewAiSummaryService;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/execute"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> execute(@RequestBody CustomPromptExecutionRequest customPromptRequest) {
        if (customPromptRequest.getPromptId() != null && customPromptRequest.getPrompt() != null) {
            throw new TrendzCustomPromptException("Please provide either prompt or promptId.");
        }
        if (customPromptRequest.getData() == null) {
            throw new CustomPromptDataNullException();
        }
        UUID customPromptExecutionUUID = this.customPromptService.runCustomPromptExecution(customPromptRequest, this.getSecurityUser());
        return ResponseEntity.ok((Object)customPromptExecutionUUID);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/view/execute"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> executeView(@RequestBody ViewAiSummaryRequest viewAiSummaryRequest) {
        if (viewAiSummaryRequest.getPromptId() != null && viewAiSummaryRequest.getPrompt() != null) {
            throw new TrendzCustomPromptException("Please provide either prompt or promptId.");
        }
        if (viewAiSummaryRequest.getViewConfig() == null || viewAiSummaryRequest.getRows() == null) {
            throw new CustomPromptDataNullException();
        }
        UUID executionId = this.viewAiSummaryService.runAiSummaryExecution(viewAiSummaryRequest, this.getSecurityUser());
        return ResponseEntity.ok((Object)executionId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<CustomPrompt> createCustomPrompt(@RequestBody CustomPromptModifyCreateRequest modifyCreateRequest) {
        if (modifyCreateRequest.getName() == null) {
            throw new CustomPromptNameNullException();
        }
        if (modifyCreateRequest.getPrompt() == null) {
            throw new CustomPromptNullException();
        }
        CustomPrompt customPrompt = this.customPromptService.createCustomPrompt(modifyCreateRequest, this.getSecurityUser());
        return ResponseEntity.ok((Object)customPrompt);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{promptId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<CustomPrompt> updateCustomPrompt(@PathVariable(value="promptId") String stringPromptId, @RequestBody CustomPromptModifyCreateRequest modifyCreateRequest) {
        if (modifyCreateRequest.getPrompt() == null && modifyCreateRequest.getName() == null) {
            throw new CustomPromptModifyRequestNullException();
        }
        UUID promptId = UUIDUtils.parse((String)stringPromptId);
        CustomPrompt customPrompt = this.customPromptService.updateCustomPrompt(promptId, modifyCreateRequest, this.getSecurityUser());
        return ResponseEntity.ok((Object)customPrompt);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<PaginationPage<CustomPromptLite>> getAllCustomPrompts(@RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="1000") String pageSizeStr, @RequestParam(value="filter", required=false, defaultValue="") List<String> filter, @RequestParam(value="sort", required=false, defaultValue="lastModifiedTs:desc") List<String> sort) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List filteringFields = filter.stream().map(CustomPromptFilteringField::fromString).collect(Collectors.toList());
        List sortingFields = sort.stream().map(CustomPromptSortingField::fromString).collect(Collectors.toList());
        Page allLite = this.customPromptService.getAllCustomPromptLite(page, pageSize, securityUser, filteringFields, sortingFields);
        PaginationPage allLitePage = new PaginationPage(allLite);
        return ResponseEntity.ok((Object)allLitePage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{promptId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<CustomPrompt> getCustomPrompt(@PathVariable(value="promptId") String stringPromptId) {
        UUID promptId = UUIDUtils.parse((String)stringPromptId);
        CustomPrompt customPrompt = this.customPromptService.getCustomPrompt(promptId, this.getSecurityUser());
        return ResponseEntity.ok((Object)customPrompt);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{promptId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteCustomPrompt(@PathVariable(value="promptId") String stringPromptId) {
        UUID promptId = UUIDUtils.parse((String)stringPromptId);
        this.customPromptService.deleteCustomPrompt(promptId, this.getSecurityUser());
        return ResponseEntity.ok((Object)"");
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/dependedEntities/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> checkDependedEntitiesBeforeDelete(@PathVariable(value="id") String strEntityId) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID entityId = UUIDUtils.parse((String)strEntityId);
        CustomPrompt entity = this.customPromptService.getCustomPrompt(entityId, user);
        if (entity.isSystem()) {
            throw new CustomPromptModificationException(entityId);
        }
        ChangeEntityValidationInfo dependedEntitiesInfo = this.customPromptService.findDependedEntities(user, entity);
        return ResponseEntity.ok((Object)dependedEntitiesInfo);
    }

    public CustomPromptController(CustomPromptService customPromptService, ViewAiSummaryService viewAiSummaryService) {
        this.customPromptService = customPromptService;
        this.viewAiSummaryService = viewAiSummaryService;
    }
}

