/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.chat.ChatConfig;
import org.thingsboard.trendz.domain.chat.ChatFilteringField;
import org.thingsboard.trendz.domain.chat.ChatInitRequest;
import org.thingsboard.trendz.domain.chat.ChatLite;
import org.thingsboard.trendz.domain.chat.ChatMessage;
import org.thingsboard.trendz.domain.chat.ChatMessageLite;
import org.thingsboard.trendz.domain.chat.ChatMessagePostRequest;
import org.thingsboard.trendz.domain.chat.ChatMessageProcessResponse;
import org.thingsboard.trendz.domain.chat.ChatMessageSortingField;
import org.thingsboard.trendz.domain.chat.ChatSortingField;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.exception.assistance.UserQuestionNullException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.chat.ChatService;
import org.thingsboard.trendz.tools.PaginationPage;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/view/assistance/"})
public class ChatController
extends BaseController {
    private final ChatService chatService;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"chats"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<ChatMessageProcessResponse> initChatWithFirstMessage(HttpServletRequest request, @RequestBody ChatInitRequest chatInitRequest) {
        if (chatInitRequest.getMessageData() == null || chatInitRequest.getMessageData().getQuestion() == null) {
            throw new UserQuestionNullException();
        }
        chatInitRequest.getMessageData().setDomain(request.getServerName());
        ChatMessageProcessResponse chatMessageProcessResponse = this.chatService.initChat(chatInitRequest, this.getSecurityUser());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)chatMessageProcessResponse);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"chats"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<PaginationPage<ChatLite>> getAllChatsLite(@RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="1000") String pageSizeStr, @RequestParam(value="filter", required=false, defaultValue="") List<String> filter, @RequestParam(value="sort", required=false, defaultValue="lastModifiedTs:desc") List<String> sort) {
        JwtSecurityUser user = this.getSecurityUser();
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List filteringFields = filter.stream().map(ChatFilteringField::fromString).collect(Collectors.toList());
        List sortingFields = sort.stream().map(ChatSortingField::fromString).collect(Collectors.toList());
        Page allLite = this.chatService.getAllChatLite(page, pageSize, user, filteringFields, sortingFields);
        PaginationPage allLitePage = new PaginationPage(allLite);
        return ResponseEntity.ok((Object)allLitePage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"chats/{chatId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ChatLite> getLiteChatById(@PathVariable(value="chatId") String stringChatId) {
        UUID chatId = UUIDUtils.parse((String)stringChatId);
        ChatLite chatLite = this.chatService.getChatLite(chatId, this.getSecurityUser());
        return ResponseEntity.ok((Object)chatLite);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"chats/{chatId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteChat(@PathVariable(value="chatId") String stringChatId) {
        UUID chatId = UUIDUtils.parse((String)stringChatId);
        this.chatService.deleteChat(chatId, this.getSecurityUser());
        return ResponseEntity.ok((Object)"");
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"chats/{chatId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> updateChat(@RequestBody ChatConfig chatConfig, @PathVariable(value="chatId") String stringChatId) {
        if (ChatType.METRIC_CODE_ASSISTANT.name().equals(chatConfig.getChatType())) {
            throw new UnsupportedOperationException("Impossible to update metric code assistance");
        }
        UUID chatId = UUIDUtils.parse((String)stringChatId);
        ChatLite chatLite = this.chatService.updateChat(chatId, chatConfig, this.getSecurityUser());
        return ResponseEntity.ok((Object)chatLite);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"chats/{chatId}/messages"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<PaginationPage<ChatMessageLite>> getLiteChatMessages(@PathVariable(value="chatId") String stringChatId, @RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="1000") String pageSizeStr, @RequestParam(value="sort", required=false, defaultValue="createdTs:desc") List<String> sort) {
        UUID chatId = UUIDUtils.parse((String)stringChatId);
        JwtSecurityUser user = this.getSecurityUser();
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List sortingFields = sort.stream().map(ChatMessageSortingField::fromString).collect(Collectors.toList());
        Page allLite = this.chatService.getAllChatMessageLite(chatId, page, pageSize, user, sortingFields);
        PaginationPage allLitePage = new PaginationPage(allLite);
        return ResponseEntity.ok((Object)allLitePage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"chats/{chatId}/messages/{messageId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ChatMessage> getChatMessageById(@PathVariable(value="chatId") String stringChatId, @PathVariable(value="messageId") String stringMessageId) {
        UUID chatId = UUIDUtils.parse((String)stringChatId);
        UUID messageId = UUIDUtils.parse((String)stringMessageId);
        ChatMessage chatMessage = this.chatService.getChatMessage(chatId, messageId, this.getSecurityUser());
        return ResponseEntity.ok((Object)chatMessage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"chats/{chatId}/messages"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<ChatMessageProcessResponse> postChatMessage(HttpServletRequest request, @PathVariable(value="chatId") String stringChatId, @RequestBody ChatMessagePostRequest chatMessagePostRequest) {
        UUID chatId = UUIDUtils.parse((String)stringChatId);
        chatMessagePostRequest.setDomain(request.getServerName());
        if (chatMessagePostRequest.getQuestion() == null) {
            throw new UserQuestionNullException();
        }
        ChatMessageProcessResponse chatMessageProcessResponse = this.chatService.postNewMessage(chatId, chatMessagePostRequest, this.getSecurityUser());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)chatMessageProcessResponse);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"chats/{chatId}/messages"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<ChatMessageProcessResponse> editLastChatMessageByChatId(HttpServletRequest request, @PathVariable(value="chatId") String stringChatId, @RequestBody ChatMessagePostRequest chatMessagePostRequest) {
        UUID chatId = UUIDUtils.parse((String)stringChatId);
        chatMessagePostRequest.setDomain(request.getServerName());
        if (chatMessagePostRequest.getQuestion() == null) {
            throw new UserQuestionNullException();
        }
        ChatMessageProcessResponse chatMessageProcessResponse = this.chatService.editLastMessage(chatId, chatMessagePostRequest, this.getSecurityUser());
        return ResponseEntity.ok((Object)chatMessageProcessResponse);
    }

    public ChatController(ChatService chatService) {
        this.chatService = chatService;
    }
}

