/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.metadata.BusinessEntityMetadataService;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/businessEntity/metadata"})
public class BusinessEntityMetadataController
extends BaseController {
    private final BusinessEntityMetadataService entityMetadataService;

    @Autowired
    public BusinessEntityMetadataController(BusinessEntityMetadataService entityMetadataService) {
        this.entityMetadataService = entityMetadataService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityId}/item"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ItemLite> getLastUsedItem(@PathVariable(value="entityId") String entityIdStr) {
        UUID entityId = UUIDUtils.parse((String)entityIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        String jwtToken = this.getJwtToken();
        ItemLite itemLite = this.entityMetadataService.getItem(entityId, user, jwtToken);
        return ResponseEntity.ok((Object)itemLite);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityId}/item"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> saveUsedItem(@PathVariable(value="entityId") String entityIdStr, @RequestBody ItemLite itemLite) {
        UUID entityId = UUIDUtils.parse((String)entityIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        this.entityMetadataService.saveItem(entityId, user, itemLite);
        return ResponseEntity.ok((Object)"");
    }
}

