/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/businessEntity"})
public class BusinessEntityController
extends BaseController {
    private final BusinessEntityService businessEntityService;

    @Autowired
    public BusinessEntityController(BusinessEntityService businessEntityService) {
        this.businessEntityService = businessEntityService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public List<BusinessEntity> getBusinessEntities() {
        JwtSecurityUser user = this.getSecurityUser();
        return this.businessEntityService.getAllEntities(user);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public BusinessEntity findById(@PathVariable(value="id") String strEntityId) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID entityId = UUID.fromString(strEntityId);
        return (BusinessEntity)this.businessEntityService.findEntityById(user, entityId).orElseThrow(() -> new BusinessEntityNotFoundException(entityId, user.getTenantId()));
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public BusinessEntity save(@RequestBody BusinessEntity businessEntity) {
        JwtSecurityUser user = this.getSecurityUser();
        return this.businessEntityService.saveEntity(user, businessEntity);
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean delete(@PathVariable(value="id") String strEntityId) {
        BusinessEntity entity = this.findById(strEntityId);
        JwtSecurityUser user = this.getSecurityUser();
        return this.businessEntityService.deleteEntity(user, entity.getId());
    }

    @RequestMapping(value={"/dependedEntities"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> checkDependedEntitiesBeforeSave(@RequestBody BusinessEntity businessEntity) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID entityId = businessEntity.getId();
        BusinessEntity oldEntity = (BusinessEntity)this.businessEntityService.findEntityById(user, entityId).orElseThrow(() -> new BusinessEntityNotFoundException(entityId, user.getTenantId()));
        ChangeEntityValidationInfo dependedEntitiesInfo = this.businessEntityService.findDependedEntities(user, oldEntity, businessEntity);
        return ResponseEntity.ok((Object)dependedEntitiesInfo);
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/dependedEntities/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> checkDependedEntitiesBeforeDelete(@PathVariable(value="id") String strEntityId) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID entityId = UUIDUtils.parse((String)strEntityId);
        BusinessEntity oldEntity = (BusinessEntity)this.businessEntityService.findEntityById(user, entityId).orElseThrow(() -> new BusinessEntityNotFoundException(entityId, user.getTenantId()));
        ChangeEntityValidationInfo dependedEntitiesInfo = this.businessEntityService.findDependedEntities(user, oldEntity, null);
        return ResponseEntity.ok((Object)dependedEntitiesInfo);
    }
}

