/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.entity.SecurityUser;
import org.thingsboard.trendz.security.service.TokenExtractor;

public abstract class BaseController {
    @Autowired
    private TokenExtractor tokenExtractor;

    protected boolean isAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && authentication.getPrincipal() instanceof SecurityUser;
    }

    protected String getJwtToken() {
        if (!this.isAuthenticated()) {
            throw new IllegalStateException("You aren't authorized to perform this operation!");
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return ((SecurityUser)authentication.getPrincipal()).getAuthToken().getToken();
    }

    protected JwtSecurityUser getSecurityUser() {
        return this.tokenExtractor.extractUser(this.getJwtToken());
    }
}

