/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.domain.assistance.agent.AgentAi;
import org.thingsboard.trendz.domain.assistance.agent.AgentChangeRequest;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.service.assistance.agent.AgentService;

@RestController
@RequestMapping(value={"/apiTrendz/view/assistance/agent"})
@ConditionalOnExpression(value="'${deployment.cloud}:${viewAssistance.agentAdminConsole.enable}'=='false:true'")
public class AiAgentController {
    private final AgentService agentService;

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> get(@RequestParam(value="version", required=false) Integer version, @RequestParam(value="type", required=false) String type) {
        AiAgentType aiAgentType = type == null ? null : AiAgentType.valueOf((String)type);
        List result = version == null ? this.agentService.getAiAgents(aiAgentType) : this.agentService.getAiAgents(aiAgentType, version.intValue());
        return ResponseEntity.ok((Object)result);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/{type}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> post(@RequestBody AgentChangeRequest agentChangeRequest, @PathVariable(value="type") String type) {
        AiAgentType aiAgentType = AiAgentType.valueOf((String)type);
        AgentAi agentAi = this.agentService.modify(agentChangeRequest, aiAgentType);
        return ResponseEntity.ok((Object)agentAi);
    }

    public AiAgentController(AgentService agentService) {
        this.agentService = agentService;
    }
}

