/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.config;

import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.thingsboard.trendz.domain.assistance.model.LlmConfig;

@Configuration
@ConditionalOnProperty(name={"deployment.cloud"}, havingValue="true")
@ConfigurationProperties(prefix="view-assistance.model.default-settings")
public class DefaultLlmModelConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DefaultLlmModelConfiguration.class);
    private UUID defaultModelId;
    private Set<LlmConfig> llmConfigs;

    public UUID getDefaultModelId() {
        return this.defaultModelId;
    }

    public Set<LlmConfig> getLlmConfigs() {
        return this.llmConfigs;
    }

    public void setDefaultModelId(UUID defaultModelId) {
        this.defaultModelId = defaultModelId;
    }

    public void setLlmConfigs(Set<LlmConfig> llmConfigs) {
        this.llmConfigs = llmConfigs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultLlmModelConfiguration)) {
            return false;
        }
        DefaultLlmModelConfiguration other = (DefaultLlmModelConfiguration)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$defaultModelId = this.getDefaultModelId();
        UUID other$defaultModelId = other.getDefaultModelId();
        if (this$defaultModelId == null ? other$defaultModelId != null : !((Object)this$defaultModelId).equals(other$defaultModelId)) {
            return false;
        }
        Set this$llmConfigs = this.getLlmConfigs();
        Set other$llmConfigs = other.getLlmConfigs();
        return !(this$llmConfigs == null ? other$llmConfigs != null : !((Object)this$llmConfigs).equals(other$llmConfigs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultLlmModelConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $defaultModelId = this.getDefaultModelId();
        result = result * 59 + ($defaultModelId == null ? 43 : ((Object)$defaultModelId).hashCode());
        Set $llmConfigs = this.getLlmConfigs();
        result = result * 59 + ($llmConfigs == null ? 43 : ((Object)$llmConfigs).hashCode());
        return result;
    }

    public String toString() {
        return "DefaultLlmModelConfiguration(defaultModelId=" + String.valueOf(this.getDefaultModelId()) + ", llmConfigs=" + String.valueOf(this.getLlmConfigs()) + ")";
    }
}

