/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz;

import java.util.Arrays;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.thingsboard.trendz.service.install.TrendzInstallService;

/*
 * Exception performing whole class analysis ignored.
 */
@EnableJpaRepositories
@EnableAutoConfiguration
@SpringBootConfiguration
@ComponentScan(value={"org.thingsboard.trendz.service.install"})
public class TrendzInstall {
    private static final Logger log = LoggerFactory.getLogger(TrendzInstall.class);
    private static final String SPRING_CONFIG_NAME_KEY = "--spring.config.name";
    private static final String DEFAULT_SPRING_CONFIG_PARAM = "--spring.config.name=trendz";

    public static void main(String[] args) {
        TrendzInstall.setDefaultTimezone();
        SpringApplication application = new SpringApplication(new Class[]{TrendzInstall.class});
        application.setAdditionalProfiles(new String[]{"install"});
        ConfigurableApplicationContext context = application.run(TrendzInstall.updateArguments((String[])args));
        TrendzInstallService installer = (TrendzInstallService)context.getBean(TrendzInstallService.class);
        installer.launch();
    }

    private static String[] updateArguments(String[] args) {
        if (Arrays.stream(args).noneMatch(arg -> arg.startsWith("--spring.config.name"))) {
            String[] modifiedArgs = new String[args.length + 2];
            System.arraycopy(args, 0, modifiedArgs, 0, args.length);
            modifiedArgs[args.length] = "--spring.config.name=trendz";
            modifiedArgs[args.length + 1] = "--spring.main.web-application-type=none";
            return modifiedArgs;
        }
        return args;
    }

    private static void setDefaultTimezone() {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }
}

