/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
public class TrendzApplication {
    private static final String SPRING_CONFIG_NAME_KEY = "--spring.config.name";
    private static final String DEFAULT_SPRING_CONFIG_PARAM = "--spring.config.name=trendz";

    public static void main(String[] args) throws InterruptedException, IOException {
        TrendzApplication.setDefaultTimezone();
        TrendzApplication.configureHeapDumpStoring();
        SpringApplication.run(TrendzApplication.class, (String[])TrendzApplication.updateArguments((String[])args));
    }

    private static void setDefaultTimezone() {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        Locale.setDefault(Locale.US);
    }

    private static void configureHeapDumpStoring() throws IOException {
        String isDockerInstallation = System.getenv("TRENDZ_DOCKER_VERSION");
        if ("true".equals(isDockerInstallation)) {
            String pid = ManagementFactory.getRuntimeMXBean().getName();
            pid = pid.substring(0, pid.indexOf(64));
            String hostname = System.getenv("MY_POD_NAME");
            hostname = hostname == null ? "docker" : hostname;
            String heapDumpDir = System.getenv("TRENDZ_HEAP_DUMP_DIR");
            heapDumpDir = heapDumpDir == null ? "/data/heap-dumps" : heapDumpDir;
            String date = new SimpleDateFormat("yyyy.MM.dd.HH:mm:ss").format(new Date());
            String fileName = heapDumpDir + "/heap_" + hostname + "__pid_" + pid + "__" + date + ".hprof";
            HotSpotDiagnosticMXBean bean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
            bean.setVMOption("HeapDumpOnOutOfMemoryError", "true");
            bean.setVMOption("HeapDumpPath", fileName);
        }
    }

    private static String[] updateArguments(String[] args) {
        if (Arrays.stream(args).noneMatch(arg -> arg.startsWith("--spring.config.name"))) {
            String[] modifiedArgs = new String[args.length + 1];
            System.arraycopy(args, 0, modifiedArgs, 0, args.length);
            modifiedArgs[args.length] = "--spring.config.name=trendz";
            return modifiedArgs;
        }
        return args;
    }
}

