### 💡 Solution Description

The **Water Metering** template is a production-ready accelerator for Smart Water projects. It solves the complexity of managing distributed meter networks by providing a unified interface for data collection, device lifecycle management, and customer engagement.

#### 🌟 Why use this template?

* **🤝 Built for Supplier Models:** This solution supports a hierarchical model where **You** (the Utility/Landlord) manage the infrastructure, while **Your Customers** get a private view of their consumption.
* **🛡️ Smart Alerting:** Unnoticed leaks and dead batteries waste resources. The system splits alarms into two streams: **Maintenance Alerts** for your engineering team and **Usage Alerts** for your customers.
* **⚡ From Pulses to Insights:** Raw meter data (pulses) is difficult to analyze. This solution uses **Calculated Fields** to automatically aggregate it into **Daily, and Weekly** consumption values for clear reporting.

#### ✨ Key Features

* **Multi-Customer Management:** Create new customers and assign devices to them directly from the Admin Dashboard. The system handles the ownership transfer and permission scopes automatically.
* **Automated Device Assignment:** Instantly move a meter from your "Warehouse" (Tenant) to a "Client" (Customer) using the built-in edit actions.
* **Intelligent Routing:** "Leakage" and "Inactivity" alerts are routed to the Tenant Admin, while "High Weekly Consumption" alerts are shared with the Customer to help them manage their property.

#### 🌍 Real-World Applications

This template serves as a robust foundation for various sectors:

* **🏙️ Municipal Utilities:**
  Automate meter reading (AMR) and provide citizens with a transparency portal to monitor their usage.

* **🏢 Commercial Real Estate:**
  Implement sub-metering for tenant units in shopping malls or office parks, assigning specific meters to specific store owners.

* **🏭 Industrial Facilities:**
  Monitor water usage in manufacturing processes to detect inefficiencies or leaks instantly.
