/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.pe.twilio.voice;

import com.google.common.util.concurrent.ListenableFuture;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.api.v2010.account.Call;
import com.twilio.twiml.VoiceResponse;
import com.twilio.twiml.voice.Pause;
import com.twilio.twiml.voice.Say;
import com.twilio.twiml.voice.SsmlProsody;
import com.twilio.type.Endpoint;
import com.twilio.type.PhoneNumber;
import com.twilio.type.Twiml;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.pe.twilio.voice.TbTwilioVoiceNodeConfiguration;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.EXTERNAL, name="twilio voice", configClazz=TbTwilioVoiceNodeConfiguration.class, nodeDescription="Sends voice message via Twilio.", nodeDetails="Will send message payload as voice message via Twilio, using Twilio text to speech service.", uiResources={"static/rulenode/twilio-config.js"}, configDirective="tbActionNodeTwilioVoiceConfig", icon="phone_in_talk", docUrl="https://thingsboard.io/docs/user-guide/rule-engine-2-0/nodes/external/twilio-voice/", hasSecrets=true)
public class TbTwilioVoiceNode
implements TbNode {
    private boolean forceAck;
    private TbTwilioVoiceNodeConfiguration config;
    private TwilioRestClient twilioRestClient;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.forceAck = ctx.isExternalNodeForceAck();
        this.config = (TbTwilioVoiceNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbTwilioVoiceNodeConfiguration.class);
        this.twilioRestClient = new TwilioRestClient.Builder(this.config.getAccountSid(), this.config.getAccountToken()).build();
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        TbMsg tbMsg = this.ackIfNeeded(ctx, msg);
        DonAsynchron.withCallback((ListenableFuture)ctx.getExternalCallExecutor().executeAsync(() -> {
            this.sendVoiceMessage(tbMsg);
            return null;
        }), ok -> {
            if (this.forceAck) {
                ctx.enqueueForTellNext(tbMsg.copyWithNewCtx(), "Success");
            } else {
                ctx.tellSuccess(tbMsg);
            }
        }, fail -> {
            if (this.forceAck) {
                ctx.enqueueForTellFailure(tbMsg.copyWithNewCtx(), fail);
            } else {
                ctx.tellFailure(tbMsg, fail);
            }
        });
    }

    private TbMsg ackIfNeeded(TbContext ctx, TbMsg msg) {
        if (this.forceAck) {
            ctx.ack(msg);
            return msg.copyWithNewCtx();
        }
        return msg;
    }

    private void sendVoiceMessage(TbMsg msg) throws Exception {
        String numberFrom = TbNodeUtils.processPattern((String)this.config.getNumberFrom(), (TbMsg)msg);
        String numbersTo = TbNodeUtils.processPattern((String)this.config.getNumbersTo(), (TbMsg)msg);
        String[] numbersToList = numbersTo.split(",");
        if (StringUtils.isBlank((String)numbersToList[0])) {
            throw new IllegalArgumentException("To numbers list is empty!");
        }
        String payload = msg.getData();
        payload = payload.substring(1, payload.length() - 1);
        Say.Language language = Say.Language.EN_US;
        for (Say.Language lang : Say.Language.values()) {
            if (!lang.toString().equals(this.config.getLanguage())) continue;
            language = lang;
            break;
        }
        Say.Voice voice = Say.Voice.MAN;
        for (Say.Voice voiceIter : Say.Voice.values()) {
            if (!voiceIter.toString().equals(this.config.getVoice())) continue;
            voice = voiceIter;
            break;
        }
        SsmlProsody prosody = new SsmlProsody.Builder(payload).pitch(this.config.getPitch().toString() + "%").rate(this.config.getRate().toString() + "%").volume(this.config.getVolume().toString() + "dB").build();
        Pause startPause = new Pause.Builder().length(this.config.getStartPause()).build();
        Say say = new Say.Builder().language(language).voice(voice).prosody(prosody).build();
        VoiceResponse response = new VoiceResponse.Builder().pause(startPause).say(say).build();
        for (String numberTo : numbersToList) {
            Call.creator((Endpoint)new PhoneNumber(numberTo.trim()), (Endpoint)new PhoneNumber(numberFrom.trim()), new Twiml(response.toXml())).create(this.twilioRestClient);
        }
    }
}

