/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OutboundCallPriceWithOrigin {
    private final double basePrice;
    private final double currentPrice;
    private final List<String> originationPrefixes;

    @JsonCreator
    public OutboundCallPriceWithOrigin(@JsonProperty(value="base_price") double basePrice, @JsonProperty(value="current_price") double currentPrice, @JsonProperty(value="origination_prefixes") List<String> originationPrefixes) {
        this.basePrice = basePrice;
        this.currentPrice = currentPrice;
        this.originationPrefixes = originationPrefixes;
    }

    public double getBasePrice() {
        return this.basePrice;
    }

    public double getCurrentPrice() {
        return this.currentPrice;
    }

    public List<String> getOriginationPrefixes() {
        return this.originationPrefixes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutboundCallPriceWithOrigin other = (OutboundCallPriceWithOrigin)o;
        return Objects.equals(this.basePrice, other.basePrice) && Objects.equals(this.currentPrice, other.currentPrice) && Objects.equals(this.originationPrefixes, other.originationPrefixes);
    }

    public int hashCode() {
        return Objects.hash(this.basePrice, this.currentPrice, this.originationPrefixes);
    }

    public String toString() {
        return "OutboundCallPriceWithOrigin(basePrice=" + this.getBasePrice() + ", currentPrice=" + this.getCurrentPrice() + ", originationPrefixes=" + this.getOriginationPrefixes() + ")";
    }
}

