/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Task
extends TwiML {
    private final Integer priority;
    private final Integer timeout;
    private final String body;

    private Task() {
        this(new Builder(null));
    }

    private Task(Builder b) {
        super("Task", b);
        this.priority = b.priority;
        this.timeout = b.timeout;
        this.body = b.body;
    }

    @Override
    protected String getElementBody() {
        return this.getBody() == null ? null : this.getBody();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getPriority() != null) {
            attrs.put("priority", this.getPriority().toString());
        }
        if (this.getTimeout() != null) {
            attrs.put("timeout", this.getTimeout().toString());
        }
        return attrs;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getBody() {
        return this.body;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private Integer priority;
        private Integer timeout;
        private String body;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Task.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(String body) {
            this.body = body;
        }

        private Builder() {
        }

        @JacksonXmlProperty(isAttribute=true, localName="priority")
        public Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="timeout")
        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Task build() {
            return new Task(this);
        }
    }
}

