/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.voice.Parameter;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Siprec
extends TwiML {
    private final String name;
    private final String connectorName;
    private final Track track;
    private final String statusCallback;
    private final StatusCallbackMethod statusCallbackMethod;

    private Siprec() {
        this(new Builder());
    }

    private Siprec(Builder b) {
        super("Siprec", b);
        this.name = b.name;
        this.connectorName = b.connectorName;
        this.track = b.track;
        this.statusCallback = b.statusCallback;
        this.statusCallbackMethod = b.statusCallbackMethod;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getName() != null) {
            attrs.put("name", this.getName());
        }
        if (this.getConnectorName() != null) {
            attrs.put("connectorName", this.getConnectorName());
        }
        if (this.getTrack() != null) {
            attrs.put("track", this.getTrack().toString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback());
        }
        if (this.getStatusCallbackMethod() != null) {
            attrs.put("statusCallbackMethod", this.getStatusCallbackMethod().toString());
        }
        return attrs;
    }

    public String getName() {
        return this.name;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public Track getTrack() {
        return this.track;
    }

    public String getStatusCallback() {
        return this.statusCallback;
    }

    public StatusCallbackMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private String name;
        private String connectorName;
        private Track track;
        private String statusCallback;
        private StatusCallbackMethod statusCallbackMethod;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Siprec.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        @JacksonXmlProperty(isAttribute=true, localName="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="connectorName")
        public Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="track")
        public Builder track(Track track) {
            this.track = track;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallback")
        public Builder statusCallback(String statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallbackMethod")
        public Builder statusCallbackMethod(StatusCallbackMethod statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Parameter")
        public Builder parameter(Parameter parameter) {
            this.children.add(parameter);
            return this;
        }

        public Siprec build() {
            return new Siprec(this);
        }
    }

    public static enum StatusCallbackMethod {
        GET("GET"),
        POST("POST");

        private final String value;

        private StatusCallbackMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Track {
        INBOUND_TRACK("inbound_track"),
        OUTBOUND_TRACK("outbound_track"),
        BOTH_TRACKS("both_tracks");

        private final String value;

        private Track(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

