/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.twilio.converter.Promoter;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import java.net.URI;

@JsonDeserialize(builder=Builder.class)
public class ReferSip
extends TwiML {
    private final URI sipUrl;

    private ReferSip() {
        this(new Builder((URI)null));
    }

    private ReferSip(Builder b) {
        super("Sip", b);
        this.sipUrl = b.sipUrl;
    }

    @Override
    protected String getElementBody() {
        return this.getSipUrl() == null ? null : this.getSipUrl().toString();
    }

    public URI getSipUrl() {
        return this.sipUrl;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private URI sipUrl;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a ReferSip.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(URI sipUrl) {
            this.sipUrl = sipUrl;
        }

        public Builder(String sipUrl) {
            this.sipUrl = Promoter.uriFromString(sipUrl);
        }

        private Builder() {
        }

        public ReferSip build() {
            return new ReferSip(this);
        }
    }
}

