/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.voice.Pause;
import com.twilio.twiml.voice.Play;
import com.twilio.twiml.voice.Say;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Prompt
extends TwiML {
    private final For for_;
    private final List<ErrorType> errorType;
    private final List<CardType> cardType;
    private final List<Integer> attempt;
    private final Boolean requireMatchingInputs;

    private Prompt() {
        this(new Builder());
    }

    private Prompt(Builder b) {
        super("Prompt", b);
        this.for_ = b.for_;
        this.errorType = b.errorType;
        this.cardType = b.cardType;
        this.attempt = b.attempt;
        this.requireMatchingInputs = b.requireMatchingInputs;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getFor_() != null) {
            attrs.put("for_", this.getFor_().toString());
        }
        if (this.getErrorTypes() != null) {
            attrs.put("errorType", this.getErrorTypesAsString());
        }
        if (this.getCardTypes() != null) {
            attrs.put("cardType", this.getCardTypesAsString());
        }
        if (this.getAttempts() != null) {
            attrs.put("attempt", this.getAttemptsAsString());
        }
        if (this.isRequireMatchingInputs() != null) {
            attrs.put("requireMatchingInputs", this.isRequireMatchingInputs().toString());
        }
        return attrs;
    }

    public For getFor_() {
        return this.for_;
    }

    public List<ErrorType> getErrorTypes() {
        return this.errorType;
    }

    protected String getErrorTypesAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<ErrorType> iter = this.getErrorTypes().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public List<CardType> getCardTypes() {
        return this.cardType;
    }

    protected String getCardTypesAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<CardType> iter = this.getCardTypes().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public List<Integer> getAttempts() {
        return this.attempt;
    }

    protected String getAttemptsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Integer> iter = this.getAttempts().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public Boolean isRequireMatchingInputs() {
        return this.requireMatchingInputs;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private For for_;
        private List<ErrorType> errorType;
        private List<CardType> cardType;
        private List<Integer> attempt;
        private Boolean requireMatchingInputs;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Prompt.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        @JacksonXmlProperty(isAttribute=true, localName="for")
        public Builder for_(For for_) {
            this.for_ = for_;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="errorType")
        public Builder errorTypes(List<ErrorType> errorType) {
            this.errorType = errorType;
            return this;
        }

        public Builder errorTypes(ErrorType errorType) {
            this.errorType = Promoter.listOfOne(errorType);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="cardType")
        public Builder cardTypes(List<CardType> cardType) {
            this.cardType = cardType;
            return this;
        }

        public Builder cardTypes(CardType cardType) {
            this.cardType = Promoter.listOfOne(cardType);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="attempt")
        public Builder attempts(List<Integer> attempt) {
            this.attempt = attempt;
            return this;
        }

        public Builder attempts(Integer attempt) {
            this.attempt = Promoter.listOfOne(attempt);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="requireMatchingInputs")
        public Builder requireMatchingInputs(Boolean requireMatchingInputs) {
            this.requireMatchingInputs = requireMatchingInputs;
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Say")
        public Builder say(Say say) {
            this.children.add(say);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Play")
        public Builder play(Play play) {
            this.children.add(play);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Pause")
        public Builder pause(Pause pause) {
            this.children.add(pause);
            return this;
        }

        public Prompt build() {
            return new Prompt(this);
        }
    }

    public static enum CardType {
        VISA("visa"),
        MASTERCARD("mastercard"),
        AMEX("amex"),
        MAESTRO("maestro"),
        DISCOVER("discover"),
        OPTIMA("optima"),
        JCB("jcb"),
        DINERS_CLUB("diners-club"),
        ENROUTE("enroute");

        private final String value;

        private CardType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ErrorType {
        TIMEOUT("timeout"),
        INVALID_CARD_NUMBER("invalid-card-number"),
        INVALID_CARD_TYPE("invalid-card-type"),
        INVALID_DATE("invalid-date"),
        INVALID_SECURITY_CODE("invalid-security-code"),
        INTERNAL_ERROR("internal-error"),
        INPUT_MATCHING_FAILED("input-matching-failed");

        private final String value;

        private ErrorType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum For {
        PAYMENT_CARD_NUMBER("payment-card-number"),
        EXPIRATION_DATE("expiration-date"),
        SECURITY_CODE("security-code"),
        POSTAL_CODE("postal-code"),
        PAYMENT_PROCESSING("payment-processing"),
        BANK_ACCOUNT_NUMBER("bank-account-number"),
        BANK_ROUTING_NUMBER("bank-routing-number");

        private final String value;

        private For(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

