/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Play
extends TwiML {
    private final Integer loop;
    private final String digits;
    private final URI url;

    private Play() {
        this(new Builder());
    }

    private Play(Builder b) {
        super("Play", b);
        this.loop = b.loop;
        this.digits = b.digits;
        this.url = b.url;
    }

    @Override
    protected String getElementBody() {
        return this.getUrl() == null ? null : this.getUrl().toString();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getLoop() != null) {
            attrs.put("loop", this.getLoop().toString());
        }
        if (this.getDigits() != null) {
            attrs.put("digits", this.getDigits());
        }
        return attrs;
    }

    public Integer getLoop() {
        return this.loop;
    }

    public String getDigits() {
        return this.digits;
    }

    public URI getUrl() {
        return this.url;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private Integer loop;
        private String digits;
        private URI url;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Play.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(URI url) {
            this.url = url;
        }

        public Builder(String url) {
            this.url = Promoter.uriFromString(url);
        }

        public Builder() {
        }

        @JacksonXmlProperty(isAttribute=true, localName="loop")
        public Builder loop(Integer loop) {
            this.loop = loop;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="digits")
        public Builder digits(String digits) {
            this.digits = digits;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="url")
        public Builder url(URI url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Promoter.uriFromString(url);
            return this;
        }

        public Play build() {
            return new Play(this);
        }
    }
}

