/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.voice.Task;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Enqueue
extends TwiML {
    private final URI action;
    private final Integer maxQueueSize;
    private final HttpMethod method;
    private final URI waitUrl;
    private final HttpMethod waitUrlMethod;
    private final String workflowSid;
    private final String name;

    private Enqueue() {
        this(new Builder());
    }

    private Enqueue(Builder b) {
        super("Enqueue", b);
        this.action = b.action;
        this.maxQueueSize = b.maxQueueSize;
        this.method = b.method;
        this.waitUrl = b.waitUrl;
        this.waitUrlMethod = b.waitUrlMethod;
        this.workflowSid = b.workflowSid;
        this.name = b.name;
    }

    @Override
    protected String getElementBody() {
        return this.getName() == null ? null : this.getName();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMaxQueueSize() != null) {
            attrs.put("maxQueueSize", this.getMaxQueueSize().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getWaitUrl() != null) {
            attrs.put("waitUrl", this.getWaitUrl().toString());
        }
        if (this.getWaitUrlMethod() != null) {
            attrs.put("waitUrlMethod", this.getWaitUrlMethod().toString());
        }
        if (this.getWorkflowSid() != null) {
            attrs.put("workflowSid", this.getWorkflowSid());
        }
        return attrs;
    }

    public URI getAction() {
        return this.action;
    }

    public Integer getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getWaitUrl() {
        return this.waitUrl;
    }

    public HttpMethod getWaitUrlMethod() {
        return this.waitUrlMethod;
    }

    public String getWorkflowSid() {
        return this.workflowSid;
    }

    public String getName() {
        return this.name;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private URI action;
        private Integer maxQueueSize;
        private HttpMethod method;
        private URI waitUrl;
        private HttpMethod waitUrlMethod;
        private String workflowSid;
        private String name;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Enqueue.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(String name) {
            this.name = name;
        }

        public Builder() {
        }

        @JacksonXmlProperty(isAttribute=true, localName="action")
        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="maxQueueSize")
        public Builder maxQueueSize(Integer maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="waitUrl")
        public Builder waitUrl(URI waitUrl) {
            this.waitUrl = waitUrl;
            return this;
        }

        public Builder waitUrl(String waitUrl) {
            this.waitUrl = Promoter.uriFromString(waitUrl);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="waitUrlMethod")
        public Builder waitUrlMethod(HttpMethod waitUrlMethod) {
            this.waitUrlMethod = waitUrlMethod;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="workflowSid")
        public Builder workflowSid(String workflowSid) {
            this.workflowSid = workflowSid;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Task")
        public Builder task(Task task) {
            this.children.add(task);
            return this;
        }

        public Enqueue build() {
            return new Enqueue(this);
        }
    }
}

