/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Conversation
extends TwiML {
    private final String serviceInstanceSid;
    private final Boolean inboundAutocreation;
    private final Integer routingAssignmentTimeout;
    private final Integer inboundTimeout;
    private final URI url;
    private final HttpMethod method;
    private final Record record;
    private final Trim trim;
    private final URI recordingStatusCallback;
    private final HttpMethod recordingStatusCallbackMethod;
    private final List<RecordingEvent> recordingStatusCallbackEvent;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final List<Event> statusCallbackEvent;

    private Conversation() {
        this(new Builder());
    }

    private Conversation(Builder b) {
        super("Conversation", b);
        this.serviceInstanceSid = b.serviceInstanceSid;
        this.inboundAutocreation = b.inboundAutocreation;
        this.routingAssignmentTimeout = b.routingAssignmentTimeout;
        this.inboundTimeout = b.inboundTimeout;
        this.url = b.url;
        this.method = b.method;
        this.record = b.record;
        this.trim = b.trim;
        this.recordingStatusCallback = b.recordingStatusCallback;
        this.recordingStatusCallbackMethod = b.recordingStatusCallbackMethod;
        this.recordingStatusCallbackEvent = b.recordingStatusCallbackEvent;
        this.statusCallback = b.statusCallback;
        this.statusCallbackMethod = b.statusCallbackMethod;
        this.statusCallbackEvent = b.statusCallbackEvent;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getServiceInstanceSid() != null) {
            attrs.put("serviceInstanceSid", this.getServiceInstanceSid());
        }
        if (this.isInboundAutocreation() != null) {
            attrs.put("inboundAutocreation", this.isInboundAutocreation().toString());
        }
        if (this.getRoutingAssignmentTimeout() != null) {
            attrs.put("routingAssignmentTimeout", this.getRoutingAssignmentTimeout().toString());
        }
        if (this.getInboundTimeout() != null) {
            attrs.put("inboundTimeout", this.getInboundTimeout().toString());
        }
        if (this.getUrl() != null) {
            attrs.put("url", this.getUrl().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getRecord() != null) {
            attrs.put("record", this.getRecord().toString());
        }
        if (this.getTrim() != null) {
            attrs.put("trim", this.getTrim().toString());
        }
        if (this.getRecordingStatusCallback() != null) {
            attrs.put("recordingStatusCallback", this.getRecordingStatusCallback().toString());
        }
        if (this.getRecordingStatusCallbackMethod() != null) {
            attrs.put("recordingStatusCallbackMethod", this.getRecordingStatusCallbackMethod().toString());
        }
        if (this.getRecordingStatusCallbackEvents() != null) {
            attrs.put("recordingStatusCallbackEvent", this.getRecordingStatusCallbackEventsAsString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback().toString());
        }
        if (this.getStatusCallbackMethod() != null) {
            attrs.put("statusCallbackMethod", this.getStatusCallbackMethod().toString());
        }
        if (this.getStatusCallbackEvents() != null) {
            attrs.put("statusCallbackEvent", this.getStatusCallbackEventsAsString());
        }
        return attrs;
    }

    public String getServiceInstanceSid() {
        return this.serviceInstanceSid;
    }

    public Boolean isInboundAutocreation() {
        return this.inboundAutocreation;
    }

    public Integer getRoutingAssignmentTimeout() {
        return this.routingAssignmentTimeout;
    }

    public Integer getInboundTimeout() {
        return this.inboundTimeout;
    }

    public URI getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Record getRecord() {
        return this.record;
    }

    public Trim getTrim() {
        return this.trim;
    }

    public URI getRecordingStatusCallback() {
        return this.recordingStatusCallback;
    }

    public HttpMethod getRecordingStatusCallbackMethod() {
        return this.recordingStatusCallbackMethod;
    }

    public List<RecordingEvent> getRecordingStatusCallbackEvents() {
        return this.recordingStatusCallbackEvent;
    }

    protected String getRecordingStatusCallbackEventsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<RecordingEvent> iter = this.getRecordingStatusCallbackEvents().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public URI getStatusCallback() {
        return this.statusCallback;
    }

    public HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public List<Event> getStatusCallbackEvents() {
        return this.statusCallbackEvent;
    }

    protected String getStatusCallbackEventsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Event> iter = this.getStatusCallbackEvents().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private String serviceInstanceSid;
        private Boolean inboundAutocreation;
        private Integer routingAssignmentTimeout;
        private Integer inboundTimeout;
        private URI url;
        private HttpMethod method;
        private Record record;
        private Trim trim;
        private URI recordingStatusCallback;
        private HttpMethod recordingStatusCallbackMethod;
        private List<RecordingEvent> recordingStatusCallbackEvent;
        private URI statusCallback;
        private HttpMethod statusCallbackMethod;
        private List<Event> statusCallbackEvent;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Conversation.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        @JacksonXmlProperty(isAttribute=true, localName="serviceInstanceSid")
        public Builder serviceInstanceSid(String serviceInstanceSid) {
            this.serviceInstanceSid = serviceInstanceSid;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="inboundAutocreation")
        public Builder inboundAutocreation(Boolean inboundAutocreation) {
            this.inboundAutocreation = inboundAutocreation;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="routingAssignmentTimeout")
        public Builder routingAssignmentTimeout(Integer routingAssignmentTimeout) {
            this.routingAssignmentTimeout = routingAssignmentTimeout;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="inboundTimeout")
        public Builder inboundTimeout(Integer inboundTimeout) {
            this.inboundTimeout = inboundTimeout;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="url")
        public Builder url(URI url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Promoter.uriFromString(url);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="record")
        public Builder record(Record record) {
            this.record = record;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="trim")
        public Builder trim(Trim trim) {
            this.trim = trim;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="recordingStatusCallback")
        public Builder recordingStatusCallback(URI recordingStatusCallback) {
            this.recordingStatusCallback = recordingStatusCallback;
            return this;
        }

        public Builder recordingStatusCallback(String recordingStatusCallback) {
            this.recordingStatusCallback = Promoter.uriFromString(recordingStatusCallback);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="recordingStatusCallbackMethod")
        public Builder recordingStatusCallbackMethod(HttpMethod recordingStatusCallbackMethod) {
            this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="recordingStatusCallbackEvent")
        public Builder recordingStatusCallbackEvents(List<RecordingEvent> recordingStatusCallbackEvent) {
            this.recordingStatusCallbackEvent = recordingStatusCallbackEvent;
            return this;
        }

        public Builder recordingStatusCallbackEvents(RecordingEvent recordingStatusCallbackEvent) {
            this.recordingStatusCallbackEvent = Promoter.listOfOne(recordingStatusCallbackEvent);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallback")
        public Builder statusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        public Builder statusCallback(String statusCallback) {
            this.statusCallback = Promoter.uriFromString(statusCallback);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallbackMethod")
        public Builder statusCallbackMethod(HttpMethod statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallbackEvent")
        public Builder statusCallbackEvents(List<Event> statusCallbackEvent) {
            this.statusCallbackEvent = statusCallbackEvent;
            return this;
        }

        public Builder statusCallbackEvents(Event statusCallbackEvent) {
            this.statusCallbackEvent = Promoter.listOfOne(statusCallbackEvent);
            return this;
        }

        public Conversation build() {
            return new Conversation(this);
        }
    }

    public static enum Event {
        CALL_INITIATED("call-initiated"),
        CALL_RINGING("call-ringing"),
        CALL_ANSWERED("call-answered"),
        CALL_COMPLETED("call-completed");

        private final String value;

        private Event(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum RecordingEvent {
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        ABSENT("absent");

        private final String value;

        private RecordingEvent(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Trim {
        TRIM_SILENCE("trim-silence"),
        DO_NOT_TRIM("do-not-trim");

        private final String value;

        private Trim(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Record {
        DO_NOT_RECORD("do-not-record"),
        RECORD_FROM_ANSWER("record-from-answer"),
        RECORD_FROM_RINGING("record-from-ringing"),
        RECORD_FROM_ANSWER_DUAL("record-from-answer-dual"),
        RECORD_FROM_RINGING_DUAL("record-from-ringing-dual"),
        TRUE("true"),
        FALSE("false");

        private final String value;

        private Record(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

