/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Config
extends TwiML {
    private final String name;
    private final String value;

    private Config() {
        this(new Builder());
    }

    private Config(Builder b) {
        super("Config", b);
        this.name = b.name;
        this.value = b.value;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getName() != null) {
            attrs.put("name", this.getName());
        }
        if (this.getValue() != null) {
            attrs.put("value", this.getValue());
        }
        return attrs;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private String name;
        private String value;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Config.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        @JacksonXmlProperty(isAttribute=true, localName="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="value")
        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Config build() {
            return new Config(this);
        }
    }
}

