/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.messaging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import com.twilio.twiml.messaging.Body;
import com.twilio.twiml.messaging.Media;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class Message
extends TwiML {
    private final String to;
    private final String from;
    private final URI action;
    private final HttpMethod method;
    private final URI statusCallback;
    private final String body;

    private Message() {
        this(new Builder());
    }

    private Message(Builder b) {
        super("Message", b);
        this.to = b.to;
        this.from = b.from;
        this.action = b.action;
        this.method = b.method;
        this.statusCallback = b.statusCallback;
        this.body = b.body;
    }

    @Override
    protected String getElementBody() {
        return this.getBody() == null ? null : this.getBody();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getTo() != null) {
            attrs.put("to", this.getTo());
        }
        if (this.getFrom() != null) {
            attrs.put("from", this.getFrom());
        }
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback().toString());
        }
        return attrs;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public URI getAction() {
        return this.action;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getStatusCallback() {
        return this.statusCallback;
    }

    public String getBody() {
        return this.body;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private String to;
        private String from;
        private URI action;
        private HttpMethod method;
        private URI statusCallback;
        private String body;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Message.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(String body) {
            this.body = body;
        }

        public Builder() {
        }

        @JacksonXmlProperty(isAttribute=true, localName="to")
        public Builder to(String to) {
            this.to = to;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="from")
        public Builder from(String from) {
            this.from = from;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="action")
        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="method")
        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        @JacksonXmlProperty(isAttribute=true, localName="statusCallback")
        public Builder statusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        public Builder statusCallback(String statusCallback) {
            this.statusCallback = Promoter.uriFromString(statusCallback);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Body")
        public Builder body(Body body) {
            this.children.add(body);
            return this;
        }

        @JacksonXmlProperty(isAttribute=false, localName="Media")
        public Builder media(Media media) {
            this.children.add(media);
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }
}

