/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.messaging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.twilio.converter.Promoter;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.TwiMLException;
import java.net.URI;

@JsonDeserialize(builder=Builder.class)
public class Media
extends TwiML {
    private final URI url;

    private Media() {
        this(new Builder((URI)null));
    }

    private Media(Builder b) {
        super("Media", b);
        this.url = b.url;
    }

    @Override
    protected String getElementBody() {
        return this.getUrl() == null ? null : this.getUrl().toString();
    }

    public URI getUrl() {
        return this.url;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends TwiML.Builder<Builder> {
        private URI url;

        public static Builder fromXml(String xml) throws TwiMLException {
            try {
                return OBJECT_MAPPER.readValue(xml, Builder.class);
            }
            catch (JsonProcessingException jpe) {
                throw new TwiMLException("Failed to deserialize a Media.Builder from the provided XML string: " + jpe.getMessage());
            }
            catch (Exception e) {
                throw new TwiMLException("Unhandled exception: " + e.getMessage());
            }
        }

        public Builder(URI url) {
            this.url = url;
        }

        public Builder(String url) {
            this.url = Promoter.uriFromString(url);
        }

        private Builder() {
        }

        public Media build() {
            return new Media(this);
        }
    }
}

