/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1.dialingpermissions;

import com.twilio.base.Updater;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.voice.v1.dialingpermissions.Settings;

public class SettingsUpdater
extends Updater<Settings> {
    private Boolean dialingPermissionsInheritance;

    public SettingsUpdater setDialingPermissionsInheritance(Boolean dialingPermissionsInheritance) {
        this.dialingPermissionsInheritance = dialingPermissionsInheritance;
        return this;
    }

    @Override
    public Settings update(TwilioRestClient client) {
        String path = "/v1/Settings";
        Request request = new Request(HttpMethod.POST, Domains.VOICE.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Settings update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Settings.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.dialingPermissionsInheritance != null) {
            request.addPostParam("DialingPermissionsInheritance", this.dialingPermissionsInheritance.toString());
        }
    }
}

