/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room.participant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.video.v1.room.participant.SubscribedTrackFetcher;
import com.twilio.rest.video.v1.room.participant.SubscribedTrackReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SubscribedTrack
extends Resource {
    private static final long serialVersionUID = 247433416593630L;
    private final String sid;
    private final String participantSid;
    private final String publisherSid;
    private final String roomSid;
    private final String name;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final Boolean enabled;
    private final Kind kind;
    private final URI url;

    public static SubscribedTrackFetcher fetcher(String pathRoomSid, String pathParticipantSid, String pathSid) {
        return new SubscribedTrackFetcher(pathRoomSid, pathParticipantSid, pathSid);
    }

    public static SubscribedTrackReader reader(String pathRoomSid, String pathParticipantSid) {
        return new SubscribedTrackReader(pathRoomSid, pathParticipantSid);
    }

    public static SubscribedTrack fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SubscribedTrack.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SubscribedTrack fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SubscribedTrack.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SubscribedTrack(@JsonProperty(value="sid") String sid, @JsonProperty(value="participant_sid") String participantSid, @JsonProperty(value="publisher_sid") String publisherSid, @JsonProperty(value="room_sid") String roomSid, @JsonProperty(value="name") String name, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="kind") Kind kind, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.participantSid = participantSid;
        this.publisherSid = publisherSid;
        this.roomSid = roomSid;
        this.name = name;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.enabled = enabled;
        this.kind = kind;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getParticipantSid() {
        return this.participantSid;
    }

    public final String getPublisherSid() {
        return this.publisherSid;
    }

    public final String getRoomSid() {
        return this.roomSid;
    }

    public final String getName() {
        return this.name;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Boolean getEnabled() {
        return this.enabled;
    }

    public final Kind getKind() {
        return this.kind;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscribedTrack other = (SubscribedTrack)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.participantSid, other.participantSid) && Objects.equals(this.publisherSid, other.publisherSid) && Objects.equals(this.roomSid, other.roomSid) && Objects.equals(this.name, other.name) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.enabled, other.enabled) && Objects.equals((Object)this.kind, (Object)other.kind) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.participantSid, this.publisherSid, this.roomSid, this.name, this.dateCreated, this.dateUpdated, this.enabled, this.kind, this.url});
    }

    public String toString() {
        return "SubscribedTrack(sid=" + this.getSid() + ", participantSid=" + this.getParticipantSid() + ", publisherSid=" + this.getPublisherSid() + ", roomSid=" + this.getRoomSid() + ", name=" + this.getName() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", enabled=" + this.getEnabled() + ", kind=" + (Object)((Object)this.getKind()) + ", url=" + this.getUrl() + ")";
    }

    public static enum Kind {
        AUDIO("audio"),
        VIDEO("video"),
        DATA("data");

        private final String value;

        private Kind(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Kind forValue(String value) {
            return (Kind)Promoter.enumFromString((String)value, (Enum[])Kind.values());
        }
    }
}

