/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room.participant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.video.v1.room.participant.SubscribeRulesFetcher;
import com.twilio.rest.video.v1.room.participant.SubscribeRulesUpdater;
import com.twilio.type.SubscribeRule;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SubscribeRules
extends Resource {
    private static final long serialVersionUID = 5507350376020L;
    private final String participantSid;
    private final String roomSid;
    private final List<SubscribeRule> rules;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;

    public static SubscribeRulesFetcher fetcher(String pathRoomSid, String pathParticipantSid) {
        return new SubscribeRulesFetcher(pathRoomSid, pathParticipantSid);
    }

    public static SubscribeRulesUpdater updater(String pathRoomSid, String pathParticipantSid) {
        return new SubscribeRulesUpdater(pathRoomSid, pathParticipantSid);
    }

    public static SubscribeRules fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SubscribeRules.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SubscribeRules fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SubscribeRules.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SubscribeRules(@JsonProperty(value="participant_sid") String participantSid, @JsonProperty(value="room_sid") String roomSid, @JsonProperty(value="rules") List<SubscribeRule> rules, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.participantSid = participantSid;
        this.roomSid = roomSid;
        this.rules = rules;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getParticipantSid() {
        return this.participantSid;
    }

    public final String getRoomSid() {
        return this.roomSid;
    }

    public final List<SubscribeRule> getRules() {
        return this.rules;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscribeRules other = (SubscribeRules)o;
        return Objects.equals(this.participantSid, other.participantSid) && Objects.equals(this.roomSid, other.roomSid) && Objects.equals(this.rules, other.rules) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.participantSid, this.roomSid, this.rules, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return "SubscribeRules(participantSid=" + this.getParticipantSid() + ", roomSid=" + this.getRoomSid() + ", rules=" + this.getRules() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ")";
    }
}

