/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room.participant;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.room.participant.PublishedTrack;

public class PublishedTrackReader
extends Reader<PublishedTrack> {
    private String pathRoomSid;
    private String pathParticipantSid;
    private Integer pageSize;

    public PublishedTrackReader(String pathRoomSid, String pathParticipantSid) {
        this.pathRoomSid = pathRoomSid;
        this.pathParticipantSid = pathParticipantSid;
    }

    public PublishedTrackReader setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ResourceSet<PublishedTrack> read(TwilioRestClient client) {
        return new ResourceSet<PublishedTrack>(this, client, this.firstPage(client));
    }

    @Override
    public Page<PublishedTrack> firstPage(TwilioRestClient client) {
        String path = "/v1/Rooms/{RoomSid}/Participants/{ParticipantSid}/PublishedTracks";
        path = path.replace("{RoomSid}", this.pathRoomSid.toString());
        path = path.replace("{ParticipantSid}", this.pathParticipantSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.VIDEO.toString(), path);
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    private Page<PublishedTrack> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PublishedTrack read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("published_tracks", response.getContent(), PublishedTrack.class, client.getObjectMapper());
    }

    @Override
    public Page<PublishedTrack> previousPage(Page<PublishedTrack> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VIDEO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PublishedTrack> nextPage(Page<PublishedTrack> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VIDEO.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PublishedTrack> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    private void addQueryParams(Request request) {
        if (this.pageSize != null) {
            request.addQueryParam("PageSize", this.pageSize.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

