/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.room.RecordingRules;

public class RecordingRulesFetcher
extends Fetcher<RecordingRules> {
    private String pathRoomSid;

    public RecordingRulesFetcher(String pathRoomSid) {
        this.pathRoomSid = pathRoomSid;
    }

    @Override
    public RecordingRules fetch(TwilioRestClient client) {
        String path = "/v1/Rooms/{RoomSid}/RecordingRules";
        path = path.replace("{RoomSid}", this.pathRoomSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.VIDEO.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("RecordingRules fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return RecordingRules.fromJson(response.getStream(), client.getObjectMapper());
    }
}

