/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.video.v1.room.ParticipantFetcher;
import com.twilio.rest.video.v1.room.ParticipantReader;
import com.twilio.rest.video.v1.room.ParticipantUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Participant
extends Resource {
    private static final long serialVersionUID = 52808589721984L;
    private final String sid;
    private final String roomSid;
    private final String accountSid;
    private final Status status;
    private final String identity;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final ZonedDateTime startTime;
    private final ZonedDateTime endTime;
    private final Integer duration;
    private final URI url;
    private final Map<String, String> links;

    public static ParticipantFetcher fetcher(String pathRoomSid, String pathSid) {
        return new ParticipantFetcher(pathRoomSid, pathSid);
    }

    public static ParticipantReader reader(String pathRoomSid) {
        return new ParticipantReader(pathRoomSid);
    }

    public static ParticipantUpdater updater(String pathRoomSid, String pathSid) {
        return new ParticipantUpdater(pathRoomSid, pathSid);
    }

    public static Participant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Participant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Participant(@JsonProperty(value="sid") String sid, @JsonProperty(value="room_sid") String roomSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="status") Status status, @JsonProperty(value="identity") String identity, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="start_time") String startTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="duration") Integer duration, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.roomSid = roomSid;
        this.accountSid = accountSid;
        this.status = status;
        this.identity = identity;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.startTime = DateConverter.iso8601DateTimeFromString(startTime);
        this.endTime = DateConverter.iso8601DateTimeFromString(endTime);
        this.duration = duration;
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getRoomSid() {
        return this.roomSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public final ZonedDateTime getEndTime() {
        return this.endTime;
    }

    public final Integer getDuration() {
        return this.duration;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Participant other = (Participant)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.roomSid, other.roomSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.identity, other.identity) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.duration, other.duration) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.roomSid, this.accountSid, this.status, this.identity, this.dateCreated, this.dateUpdated, this.startTime, this.endTime, this.duration, this.url, this.links});
    }

    public String toString() {
        return "Participant(sid=" + this.getSid() + ", roomSid=" + this.getRoomSid() + ", accountSid=" + this.getAccountSid() + ", status=" + (Object)((Object)this.getStatus()) + ", identity=" + this.getIdentity() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", duration=" + this.getDuration() + ", url=" + this.getUrl() + ", links=" + this.getLinks() + ")";
    }

    public static enum Status {
        CONNECTED("connected"),
        DISCONNECTED("disconnected");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

