/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.CompositionHook;

public class CompositionHookFetcher
extends Fetcher<CompositionHook> {
    private String pathSid;

    public CompositionHookFetcher(String pathSid) {
        this.pathSid = pathSid;
    }

    @Override
    public CompositionHook fetch(TwilioRestClient client) {
        String path = "/v1/CompositionHooks/{Sid}";
        path = path.replace("{Sid}", this.pathSid.toString());
        Request request = new Request(HttpMethod.GET, Domains.VIDEO.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CompositionHook fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return CompositionHook.fromJson(response.getStream(), client.getObjectMapper());
    }
}

