/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.VerificationCheck;

public class VerificationCheckCreator
extends Creator<VerificationCheck> {
    private String pathServiceSid;
    private String code;
    private String to;
    private String verificationSid;
    private String amount;
    private String payee;

    public VerificationCheckCreator(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public VerificationCheckCreator setCode(String code) {
        this.code = code;
        return this;
    }

    public VerificationCheckCreator setTo(String to) {
        this.to = to;
        return this;
    }

    public VerificationCheckCreator setVerificationSid(String verificationSid) {
        this.verificationSid = verificationSid;
        return this;
    }

    public VerificationCheckCreator setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public VerificationCheckCreator setPayee(String payee) {
        this.payee = payee;
        return this;
    }

    @Override
    public VerificationCheck create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/VerificationCheck";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("VerificationCheck creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return VerificationCheck.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.code != null) {
            request.addPostParam("Code", this.code);
        }
        if (this.to != null) {
            request.addPostParam("To", this.to);
        }
        if (this.verificationSid != null) {
            request.addPostParam("VerificationSid", this.verificationSid);
        }
        if (this.amount != null) {
            request.addPostParam("Amount", this.amount);
        }
        if (this.payee != null) {
            request.addPostParam("Payee", this.payee);
        }
    }
}

