/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.RateLimit;

public class RateLimitCreator
extends Creator<RateLimit> {
    private String pathServiceSid;
    private String uniqueName;
    private String description;

    public RateLimitCreator(String pathServiceSid, String uniqueName) {
        this.pathServiceSid = pathServiceSid;
        this.uniqueName = uniqueName;
    }

    public RateLimitCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public RateLimitCreator setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public RateLimit create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/RateLimits";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{UniqueName}", this.uniqueName.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("RateLimit creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return RateLimit.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.description != null) {
            request.addPostParam("Description", this.description);
        }
    }
}

