/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.MessagingConfiguration;

public class MessagingConfigurationFetcher
extends Fetcher<MessagingConfiguration> {
    private String pathServiceSid;
    private String pathCountry;

    public MessagingConfigurationFetcher(String pathServiceSid, String pathCountry) {
        this.pathServiceSid = pathServiceSid;
        this.pathCountry = pathCountry;
    }

    @Override
    public MessagingConfiguration fetch(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/MessagingConfigurations/{Country}";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{Country}", this.pathCountry.toString());
        Request request = new Request(HttpMethod.GET, Domains.VERIFY.toString(), path);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("MessagingConfiguration fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return MessagingConfiguration.fromJson(response.getStream(), client.getObjectMapper());
    }
}

