/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.service.MessagingConfigurationCreator;
import com.twilio.rest.verify.v2.service.MessagingConfigurationDeleter;
import com.twilio.rest.verify.v2.service.MessagingConfigurationFetcher;
import com.twilio.rest.verify.v2.service.MessagingConfigurationReader;
import com.twilio.rest.verify.v2.service.MessagingConfigurationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MessagingConfiguration
extends Resource {
    private static final long serialVersionUID = 141221540042494L;
    private final String accountSid;
    private final String serviceSid;
    private final String country;
    private final String messagingServiceSid;
    private final ZonedDateTime dateCreated;
    private final ZonedDateTime dateUpdated;
    private final URI url;

    public static MessagingConfigurationCreator creator(String pathServiceSid, String country, String messagingServiceSid) {
        return new MessagingConfigurationCreator(pathServiceSid, country, messagingServiceSid);
    }

    public static MessagingConfigurationDeleter deleter(String pathServiceSid, String pathCountry) {
        return new MessagingConfigurationDeleter(pathServiceSid, pathCountry);
    }

    public static MessagingConfigurationFetcher fetcher(String pathServiceSid, String pathCountry) {
        return new MessagingConfigurationFetcher(pathServiceSid, pathCountry);
    }

    public static MessagingConfigurationReader reader(String pathServiceSid) {
        return new MessagingConfigurationReader(pathServiceSid);
    }

    public static MessagingConfigurationUpdater updater(String pathServiceSid, String pathCountry, String messagingServiceSid) {
        return new MessagingConfigurationUpdater(pathServiceSid, pathCountry, messagingServiceSid);
    }

    public static MessagingConfiguration fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, MessagingConfiguration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static MessagingConfiguration fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, MessagingConfiguration.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private MessagingConfiguration(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="country") String country, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.country = country;
        this.messagingServiceSid = messagingServiceSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getCountry() {
        return this.country;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final ZonedDateTime getDateCreated() {
        return this.dateCreated;
    }

    public final ZonedDateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingConfiguration other = (MessagingConfiguration)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.country, other.country) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.serviceSid, this.country, this.messagingServiceSid, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return "MessagingConfiguration(accountSid=" + this.getAccountSid() + ", serviceSid=" + this.getServiceSid() + ", country=" + this.getCountry() + ", messagingServiceSid=" + this.getMessagingServiceSid() + ", dateCreated=" + this.getDateCreated() + ", dateUpdated=" + this.getDateUpdated() + ", url=" + this.getUrl() + ")";
    }
}

