/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Creator;
import com.twilio.constant.EnumConstants;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.Entity;

public class EntityCreator
extends Creator<Entity> {
    private String pathServiceSid;
    private String identity;

    public EntityCreator(String pathServiceSid, String identity) {
        this.pathServiceSid = pathServiceSid;
        this.identity = identity;
    }

    public EntityCreator setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    @Override
    public Entity create(TwilioRestClient client) {
        String path = "/v2/Services/{ServiceSid}/Entities";
        path = path.replace("{ServiceSid}", this.pathServiceSid.toString());
        path = path.replace("{Identity}", this.identity.toString());
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), path);
        request.setContentType(EnumConstants.ContentType.FORM_URLENCODED);
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Entity creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return Entity.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
    }
}

