/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.VerificationAttemptsSummary;
import java.time.ZonedDateTime;

public class VerificationAttemptsSummaryFetcher
extends Fetcher<VerificationAttemptsSummary> {
    private String verifyServiceSid;
    private ZonedDateTime dateCreatedAfter;
    private ZonedDateTime dateCreatedBefore;
    private String country;
    private VerificationAttemptsSummary.Channels channel;
    private String destinationPrefix;

    public VerificationAttemptsSummaryFetcher setVerifyServiceSid(String verifyServiceSid) {
        this.verifyServiceSid = verifyServiceSid;
        return this;
    }

    public VerificationAttemptsSummaryFetcher setDateCreatedAfter(ZonedDateTime dateCreatedAfter) {
        this.dateCreatedAfter = dateCreatedAfter;
        return this;
    }

    public VerificationAttemptsSummaryFetcher setDateCreatedBefore(ZonedDateTime dateCreatedBefore) {
        this.dateCreatedBefore = dateCreatedBefore;
        return this;
    }

    public VerificationAttemptsSummaryFetcher setCountry(String country) {
        this.country = country;
        return this;
    }

    public VerificationAttemptsSummaryFetcher setChannel(VerificationAttemptsSummary.Channels channel) {
        this.channel = channel;
        return this;
    }

    public VerificationAttemptsSummaryFetcher setDestinationPrefix(String destinationPrefix) {
        this.destinationPrefix = destinationPrefix;
        return this;
    }

    @Override
    public VerificationAttemptsSummary fetch(TwilioRestClient client) {
        String path = "/v2/Attempts/Summary";
        Request request = new Request(HttpMethod.GET, Domains.VERIFY.toString(), path);
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("VerificationAttemptsSummary fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.test(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content", response.getStatusCode());
            }
            throw new ApiException(restException);
        }
        return VerificationAttemptsSummary.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.verifyServiceSid != null) {
            request.addQueryParam("VerifyServiceSid", this.verifyServiceSid);
        }
        if (this.dateCreatedAfter != null) {
            request.addQueryParam("DateCreatedAfter", this.dateCreatedAfter.toInstant().toString());
        }
        if (this.dateCreatedBefore != null) {
            request.addQueryParam("DateCreatedBefore", this.dateCreatedBefore.toInstant().toString());
        }
        if (this.country != null) {
            request.addQueryParam("Country", this.country);
        }
        if (this.channel != null) {
            request.addQueryParam("Channel", this.channel.toString());
        }
        if (this.destinationPrefix != null) {
            request.addQueryParam("DestinationPrefix", this.destinationPrefix);
        }
    }
}

